import argparse
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.utils.rtmr_resource_service.bin.releaser.lib.resource_releaser import ResourceReleaser
from crypta.utils.rtmr_resource_service.lib import config
from crypta.utils.rtmr_resource_service.lib.db_client import DbClient
from crypta.utils.rtmr_resource_service.lib.reports_client import ReportsClient


def parse_args():
    parser = argparse.ArgumentParser(description='Crypta RTMR resource releaser')
    parser.add_argument('--config', help='Config file', required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()

    kv_client = config.get_read_only_kv_client(args.config)
    retry_opts = config.get_retry_opts(args.config)

    db = DbClient(kv_client)
    reports_client = ReportsClient(kv_client, retry_opts)

    resources = config.get_resources(args.config).values()
    sandbox = config.get_sandbox_client(args.config)

    releaser = ResourceReleaser(resources, db, reports_client, sandbox, **args.config["releaser"])
    releaser.release()
