package main

import (
	"a.yandex-team.ru/crypta/lib/go/binutils"
	"a.yandex-team.ru/crypta/utils/rtmr_resource_service/bin/server/lib"
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"time"
)

func main() {
	config, err := rsserver.GetConfig()
	if err != nil {
		panic(err)
	}

	masterClient, err := rsserver.GetMasterClient(config)
	if err != nil {
		panic(err)
	}

	readOnlyClient, err := rsserver.GetReadOnlyClient(config)
	if err != nil {
		panic(err)
	}

	readOnlyDBClient := rsserver.NewReadOnlyDBClient(readOnlyClient)
	reportsClient := rsserver.NewReportsClient(masterClient, time.Duration(config.ReportTimeoutMs)*time.Millisecond)
	fileClient := rsserver.NewFileClient(&config.FileClient)
	registry := solomon.NewRegistry(solomon.NewRegistryOpts().SetRated(true))
	api := rsserver.CreateServer(
		readOnlyDBClient,
		config.Resources,
		fileClient,
		reportsClient,
		config.HTTPConfig,
		registry,
	)
	stats := rsserver.CreateStatsServer(registry, config.SolomonPort)

	binutils.RunAllAndWaitForSignal(
		binutils.MakeHTTPTask(api),
		binutils.MakeHTTPTask(stats),
	)
}
