package rsserver

import (
	"a.yandex-team.ru/crypta/lib/go/yt/kv"
	"context"
	"encoding/json"
	"strings"
)

func getKey(parts ...string) string {
	return strings.Join(parts, "/")
}

func writeJSON(ctx context.Context, client kv.Client, key string, value interface{}) error {
	serialized, err := json.Marshal(&value)
	if err != nil {
		return err
	}
	return client.Write(ctx, key, string(serialized))
}

func lookupJSON(ctx context.Context, client kv.ReadOnlyClient, key string, value interface{}) error {
	serialized, err := client.Lookup(ctx, key)
	if err != nil || serialized == nil {
		return err
	}
	return json.Unmarshal([]byte(*serialized), value)
}
