package rsserver

import (
	"context"
	"fmt"
)

type EnvName struct {
	Env  string
	Name string
}

type MockDBClient struct {
	State       map[EnvName]uint64
	ClusterEnvs map[string]string
}

func (client *MockDBClient) GetEnv(_ context.Context, dc string) (*string, error) {
	value, ok := client.ClusterEnvs[dc]
	if !ok {
		return nil, nil
	}
	return &value, nil
}

func (client *MockDBClient) GetPublicResources(_ context.Context) ([]ResourceID, error) {
	var result []ResourceID
	for key, id := range client.State {
		result = append(result, ResourceID{key.Name, key.Env, id})
	}

	return result, nil
}

func (client *MockDBClient) GetLatestResourceVersion(_ context.Context, env string, resource string) (*uint64, error) {
	version, ok := client.State[EnvName{env, resource}]
	if !ok {
		return nil, fmt.Errorf("%s/%s was not found", env, resource)
	}

	return &version, nil
}

func NewMockDBClient(state map[EnvName]uint64, clusterEnvs map[string]string) *MockDBClient {
	return &MockDBClient{
		State:       state,
		ClusterEnvs: clusterEnvs,
	}
}
