package rsserver

import (
	"context"
	"fmt"
)

type MockReportsClient struct {
	Oks      map[ResourceID][]string
	Versions map[ResourceID][]string
}

func (client *MockReportsClient) ReportVersion(_ context.Context, env string, resource string, version uint64, remoteAddr string) error {
	key := ResourceID{
		Name:        resource,
		ReleaseType: env,
		Version:     version,
	}
	client.Versions[key] = append(client.Versions[key], remoteAddr)
	return nil
}

func (client *MockReportsClient) ReportOk(_ context.Context, env string, resource string, version uint64, remoteAddr string) error {
	key := ResourceID{
		Name:        resource,
		ReleaseType: env,
		Version:     version,
	}
	client.Oks[key] = append(client.Oks[key], remoteAddr)
	return nil
}

func (client *MockReportsClient) GetReportCounts(_ context.Context, env string, resource string, version uint64) (ReportCounts, error) {
	return ReportCounts{
		OkCount:      len(client.Oks[ResourceID{resource, env, version}]),
		VersionCount: len(client.Versions[ResourceID{resource, env, version}]),
	}, nil
}

func (client *MockReportsClient) Dump() interface{} {
	return map[string]interface{}{
		"ok":      dumpReports(client.Oks),
		"version": dumpReports(client.Versions),
	}
}

func NewMockReportsClient() *MockReportsClient {
	return &MockReportsClient{
		Oks:      make(map[ResourceID][]string),
		Versions: make(map[ResourceID][]string),
	}
}

func dumpReports(reports map[ResourceID][]string) map[string][]string {
	dump := make(map[string][]string)
	for key, ids := range reports {
		dump[fmt.Sprintf("%v/%v/%v", key.ReleaseType, key.Name, key.Version)] = ids
	}
	return dump
}
