package rsserver

import (
	"encoding/json"
	"log"
	"net/http"
)

type errorMsg struct {
	Error string `json:"error"`
}

func reply(writer http.ResponseWriter, message interface{}, code int) {
	writer.WriteHeader(code)
	writer.Header().Set("Content-Type", "application/json")
	err := json.NewEncoder(writer).Encode(message)

	if err != nil {
		panic(err)
	}
}

func replyOk(writer http.ResponseWriter, message interface{}) {
	reply(writer, message, http.StatusOK)
}

func replyError(writer http.ResponseWriter, message string, code int) {
	log.Printf("Replied with code %v: %s", code, message)
	reply(writer, errorMsg{Error: message}, code)
}

func replyNotFound(writer http.ResponseWriter, message string) {
	replyError(writer, message, http.StatusNotFound)
}

func replyInternalError(writer http.ResponseWriter, err error) {
	replyError(writer, err.Error(), http.StatusInternalServerError)
}
