package rsserver

import (
	"a.yandex-team.ru/library/go/core/metrics/solomon"
	"a.yandex-team.ru/library/go/yandex/solomon/reporters/puller/httppuller"
	"fmt"
	"github.com/go-chi/chi/v5"
	"net/http"
)

func CreateStatsServer(registry *solomon.Registry, port int64) *http.Server {
	router := chi.NewRouter()

	router.Get("/sensors", httppuller.NewHandler(registry).ServeHTTP)
	router.Get("/ping", ping)

	return &http.Server{
		Handler: router,
		Addr:    fmt.Sprintf(":%v", port),
	}
}

func ping(writer http.ResponseWriter, _ *http.Request) {
	_, err := writer.Write([]byte("OK"))
	if err != nil {
		panic(err)
	}
}
