import argparse
import logging
import os

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.utils.rtmr_resource_service.bin.state_synchronizer.lib.state_synchronizer import StateSynchronizer
from crypta.utils.rtmr_resource_service.lib import config
from crypta.utils.rtmr_resource_service.lib.db_client import DbClient


def parse_args():
    parser = argparse.ArgumentParser(description='Resource service state synchronizer')
    parser.add_argument('--config', help='Config file', required=True, type=yaml_config.load)
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())
    args = parse_args()

    instance = os.getenv("QLOUD_INSTANCE", os.getenv("DEPLOY_POD_ID"))
    assert instance is not None, "Both environment variables QLOUD_INSTANCE and DEPLOY_POD_ID are undefined"

    resources = config.get_resources(args.config)

    db_client = DbClient(config.get_master_kv_client(args.config))
    file_client = config.get_file_client(args.config)
    sandbox = config.get_sandbox_client(args.config)
    retry_opts = args.config["retry_opts"]

    synchronizer = StateSynchronizer(instance, resources, file_client, db_client, sandbox, retry_opts)
    synchronizer.sync()
