import argparse
import datetime
import logging

from crypta.lib.python import yaml_config
from crypta.lib.python.logging import logging_helpers
from crypta.utils.rtmr_resource_service.bin.yt_state_updater.lib.yt_state_updater import YtStateUpdater
from crypta.utils.rtmr_resource_service.lib import config
from crypta.utils.rtmr_resource_service.lib.db_client import DbClient
from crypta.utils.rtmr_resource_service.lib.reports_client import ReportsClient


logger = logging.getLogger(__name__)


def parse_args():
    parser = argparse.ArgumentParser(description="Resource service yt state updater")
    parser.add_argument('--config', help='Config file', required=True, type=yaml_config.load)

    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()

    resources = config.get_resources(args.config)

    kv_client = config.get_master_kv_client(args.config)
    retry_opts = config.get_retry_opts(args.config)

    db_client = DbClient(kv_client)
    reports_client = ReportsClient(
        kv_client,
        retry_opts,
    )
    sandbox = config.get_sandbox_client(args.config)
    cluster_envs_config = args.config["cluster_envs"]

    report_ttl = datetime.timedelta(seconds=args.config["report_ttl_sec"])
    instance_ttl = datetime.timedelta(seconds=args.config["instance_ttl_sec"])

    updater = YtStateUpdater(resources, db_client, reports_client, sandbox, cluster_envs_config, report_ttl, instance_ttl, retry_opts)
    updater.update()
