import datetime
import os

from crypta.lib.python.sandbox.client import SandboxClient
from crypta.lib.python.yt.dyntables.cross_dc_kv_client import CrossDcKvClient
from crypta.lib.python.yt.dyntables import kv_client
from crypta.utils.rtmr_resource_service.lib.file_client import FileClient
from crypta.utils.rtmr_resource_service.lib.resource import Resource
import six


def get_read_only_kv_client(config):
    current_dc = os.getenv("QLOUD_DATACENTER", os.getenv("DEPLOY_NODE_DC"))
    assert current_dc is not None, "Both environment variables QLOUD_DATACENTER and DEPLOY_NODE_DC are undefined"
    current_dc = current_dc.upper()

    replica_config = config["replica_kv_clients"]
    replica_kv_clients = {
        dc: kv_client.make_kv_client(proxy, replica_config["path"])
        for dc, proxy in six.iteritems(replica_config["dcs"])
    }
    return CrossDcKvClient(
        replica_kv_clients[current_dc],
        [replica_kv_clients[dc] for dc in replica_kv_clients if dc != current_dc],
        datetime.timedelta(milliseconds=replica_config["retry_timeout_ms"]),
    )


def get_master_kv_client(config):
    return kv_client.make_kv_client(**config["master_kv_client"])


def get_resources(config):
    return {name: Resource(name, **resource_config) for name, resource_config in six.iteritems(config["resources"])}


def get_file_client(config):
    return FileClient(**config["file_client"])


def get_sandbox_client(config):
    return SandboxClient(os.getenv("CRYPTA_SANDBOX_OAUTH_TOKEN"))


def get_retry_opts(config):
    return config["retry_opts"]


def get_rt_retry_opts(config):
    return config["rt_retry_opts"]
