import os
import shutil


class FileClient(object):
    def __init__(self, root):
        self.root = root

    def init(self, resources):
        if not os.path.isdir(self.root):
            os.makedirs(self.root)

        existing = {
            self.get_resource_dir(resource_name)
            for resource_name in os.listdir(self.root)
        }

        needed = {
            self.get_resource_dir(resource)
            for resource in resources
        }

        for path in (existing - needed):
            shutil.rmtree(path)
        for path in (needed - existing):
            os.makedirs(path)

    def get_resource_dir(self, name):
        return os.path.join(self.root, name)

    def get_resource_filename(self, name, id_):
        return os.path.join(self.root, name, str(id_))

    def remove_extra(self, all_ids):
        present_resource_names = set(os.listdir(self.root))
        present = set()
        for name in present_resource_names:
            for id_ in os.listdir(self.get_resource_dir(name)):
                present.add((name, id_))

        all_ids = set((name, str(id_)) for name, id_ in all_ids)
        for name, id_ in present - all_ids:
            os.remove(self.get_resource_filename(name, id_))

    def is_present(self, name, id_):
        return os.path.exists(self.get_resource_filename(name, id_))
