import contextlib
import time
import six


class MockDbClient(object):
    def __init__(self, state=None, cluster_envs=None):
        self.state = state or {}

        self.cluster_envs = cluster_envs or {}

        self.resources = set()
        self.instances = {}
        self.instance_resources = {}

    def get_latest_resource_version(self, env, resource_name):
        return self.state.get(env, {}).get(resource_name)

    def set_latest_resource_version(self, env, resource_name, version):
        self.state.setdefault(env, {})[resource_name] = version

    def get_env(self, cluster):
        return self.cluster_envs.get(cluster)

    def set_env(self, cluster, env):
        self.cluster_envs[cluster] = env

    def set_resources_to_download(self, resources):
        self.resources = resources

    def get_resources_to_download(self):
        return self.resources

    def get_instance_resources(self, instance):
        return self.instance_resources.get(instance, set())

    def set_instance_resources(self, instance, resources):
        self.instance_resources[instance] = resources

    def register_instance(self, instance):
        self.instances[instance] = time.time()

    def get_instances(self):
        return set(self.instances.keys())

    def get_public_resources(self):
        return [
            (name, env, id_)
            for env, resources in six.iteritems(self.state)
            for name, id_ in six.iteritems(resources)
        ]

    @contextlib.contextmanager
    def transaction(self):
        yield
