import contextlib

from crypta.utils.rtmr_resource_service.lib import reports_client
import six


class MockReportsClient(object):
    def __init__(self, reports_ok=None, reports_version=None):
        self.reports_ok = reports_ok or {}
        self.reports_version = reports_version or {}

    def report_version(self, env, resource_name, version, client_id):
        self.reports_version.setdefault(env, {}).setdefault(resource_name, {}).setdefault(version, set()).add(client_id)

    def report_ok(self, env, resource_name, version, client_id):
        self.reports_ok.setdefault(env, {}).setdefault(resource_name, {}).setdefault(version, set()).add(client_id)

    def get_report_counts(self, env, resource_name, version):
        versions = self.reports_version.setdefault(env, {}).setdefault(resource_name, {}).setdefault(version, set())
        oks = self.reports_ok.setdefault(env, {}).setdefault(resource_name, {}).setdefault(version, set())
        return reports_client.Counts(
            version=len(versions),
            ok=len(oks),
        )

    def dump_reports(self):
        return {
            report_type: {
                env: {
                    resource: {version: list(clients) for version, clients in six.iteritems(resource_reports)}
                    for resource, resource_reports in six.iteritems(env_reports)
                }
                for env, env_reports in six.iteritems(reports)
            } for report_type, reports in [("ok", self.reports_ok), ("version", self.reports_version)]
        }

    @contextlib.contextmanager
    def transaction(self):
        yield
