import argparse
import logging
import os
import shlex

from crypta.lib.python import (
    cmd,
    period,
    yaml_config,
)
from crypta.lib.python.juggler.juggler_client import JugglerClient
from crypta.lib.python.logging import logging_helpers
from crypta.utils.run_periodic_task.lib import hosts


logger = logging.getLogger(__name__)

JUGGLER_HOSTS = {
    "production": hosts.PROD_HOST,
    "testing": hosts.TEST_HOST,
}


def parse_args():
    parser = argparse.ArgumentParser(description=__doc__)
    parser.add_argument('--config', required=True, help='Config file')
    return parser.parse_args()


def main():
    logging_helpers.configure_stdout_logger(logging.getLogger())

    args = parse_args()
    logger.info(args)

    config = yaml_config.load(args.config)
    logger.info(config)

    task_name = config["task_name"]

    juggler_client = JugglerClient(
        host=config.get("juggler_host", "juggler-push.search.yandex.net"),
        port=config.get("juggler_port", 80),
        source="crypta-run-periodic-task",
    )

    while True:
        with period.period(seconds=config["run_period_seconds"]):
            try:
                cmd.run(
                    shlex.split(config["cmd"]),
                    description="Run {}".format(task_name),
                    env=dict(os.environ, **config["env"]) if "env" in config else None,
                )

                if config["enable_task_monitoring"]:
                    juggler_client.send_ok(JUGGLER_HOSTS[os.environ["CRYPTA_ENVIRONMENT"]], config["task_name"], "OK")

            except Exception:
                logger.exception("")
