#!/usr/bin/python
# -*- coding: utf-8 -*-
from vault_client import instances

CRYPTA_GROUP_NAME = 'crypta'
CRYPTA_STAFF_GROUP_ID = 302
ROBOT_SECRETARY_STAFF_UID = 1120000000034830
VAULT_CLIENT = instances.Testing()  # instances.Production() for production

SECRET_COMMENT_TEMPLATE = 'Этот %s залит автоматически'


def _get_client_of_environment(is_production):
    return instances.Production() if is_production else instances.Testing()


class CryptaVaultClient:
    def __init__(self, is_production):
        self.client = _get_client_of_environment(is_production)

    def set_client_of_environment(self, is_production):
        self.client = _get_client_of_environment(is_production)

    def store(self, secret_name, secret):
        tags = '%s,%s,%s' % (CRYPTA_GROUP_NAME, secret_name, secret.type)

        secrets_dict = [{'key': secret.type, 'value': secret.value}]
        secret_uuid = self.client.create_secret(
            secret_name,
            tags=tags,
            comment=SECRET_COMMENT_TEMPLATE % secret.type
        )

        self.client.add_user_role_to_secret(secret_uuid, 'owner', staff_id=CRYPTA_STAFF_GROUP_ID)
        self.client.add_user_role_to_secret(secret_uuid, 'reader', uid=ROBOT_SECRETARY_STAFF_UID)

        secret_version = self.client.create_secret_version(
            secret_uuid,
            value=secrets_dict
        )

        # Uncomment for debug purposes
        # retrieved_version = VAULT_CLIENT.get_version(secret_version)
        # print '\nGot secret:', retrieved_version
