#!/usr/bin/python


class VaultSecret:
    SECRET_TYPE_DEFAULT = 'secret'
    SECRET_TYPE_PASSWORD = 'password'
    SECRET_TYPE_TOKEN = 'token'
    SECRET_TYPE_OAUTH = 'oauth'
    SECRET_TYPE_PRIVATE_KEY = 'id_rsa'
    SECRET_TYPE_PUBLIC_KEY = 'id_rsa.pub'

    def __init__(self, secret_name, secret_value):
        self.name = secret_name
        self.value = secret_value
        self.type = self.SECRET_TYPE_DEFAULT

        self.set_type_by_name(secret_name)

    def set_type_by_name(self, name):
        for type_candidate in [
            self.SECRET_TYPE_PASSWORD, self.SECRET_TYPE_TOKEN, self.SECRET_TYPE_OAUTH, self.SECRET_TYPE_PRIVATE_KEY,
            self.SECRET_TYPE_PUBLIC_KEY
        ]:
            if self.SECRET_TYPE_PRIVATE_KEY in name.lower():
                self.type = 'private_key'
                break
            elif self.SECRET_TYPE_PUBLIC_KEY in name.lower():
                self.type = 'public_key'
                break
            elif type_candidate.lower() in name.lower():
                self.type = type_candidate
                break


def test_simple():
    password = VaultSecret('some_password', 'password 1')
    token = VaultSecret('some_token', 'token 2')
    oauth = VaultSecret('some_oauth', 'oauth 3')
    default = VaultSecret('some_anything', 'anything 4')

    def print_secret(test_secret):
        print 'Check if secret created correctly:',\
            "\tname:", test_secret.name,\
            "\ttype:", test_secret.type,\
            '\tvalue:', test_secret.value

    for secret in (password, token, oauth, default):
        print_secret(secret)


if __name__ == "__main__":
    test_simple()

