#include <crypta/lib/native/cmd_args/parse_pb_options.h>
#include <crypta/utils/socket_filter/lib/reader.h>
#include <crypta/utils/socket_filter/proto/options.pb.h>

THolder<TFilteredReader> readerPtr = nullptr;
void SigHandler(int) {
    readerPtr->Stop();
}

int main(int argc, const char** argv) {
    try {
        auto config = NCrypta::ParsePbOptionsExtended<TFilteredReaderOptions>(argc, argv);
        signal(SIGTERM, SigHandler);
        signal(SIGINT, SigHandler);

        Cerr << "Reading: " << config.GetLogbrokerOptions().GetServer() << "/"
                 << config.GetLogbrokerOptions().GetTopic() << " by "
                 << config.GetTvmOptions().GetClientAlias() << ". "
                 << "Locked sessions: " << config.GetLogbrokerOptions().GetUseLockSession() << Endl;

        readerPtr = MakeHolder<TFilteredReader>(config);
        readerPtr->Start();
    } catch (const yexception& e) {
        Cerr << e.what() << Endl;
        return 1;
    }

    return 0;
}
