#include "lbwrapper.h"
#include <util/string/cast.h>
#include <util/generic/ptr.h>

using NPersQueue::CreateTVMCredentialsProvider;
using NPersQueue::ICredentialsProvider;
using NPersQueue::ILogger;
using NPersQueue::TConsumerSettings;
using NPersQueue::TPQLibSettings;

using NCryptaLogbroker::CreateTvmProvider;
using NCryptaLogbroker::TLogbrokerPuller;
using TLogbrokerOptions = TFilteredReaderOptions::TLogbrokerOptions;

THolder<TLogbrokerPuller> CreateLogBrokerPuller(const TLogbrokerOptions& options, const TTvmKeyManager& tvmKeyManager, NMonitoring::TLabels commonLabels) {
    TPQLibSettings pqSettings;
    TConsumerSettings consumerSettings;

    pqSettings.ThreadsCount = options.GetThreadsCount();

    consumerSettings.Server = NPersQueue::TServerSetting{
        options.GetServer(),
        static_cast<ui16>(options.GetPort())};
    consumerSettings.Topics.push_back(options.GetTopic());
    consumerSettings.ClientId = tvmKeyManager.GetClientAlias();
    consumerSettings.MaxInflyRequests = options.GetMaxInflyRequests();
    consumerSettings.MaxMemoryUsage = options.GetMaxMemoryUsage();
    consumerSettings.UseLockSession = options.GetUseLockSession();
    consumerSettings.ReadMirroredPartitions = options.GetReadMirroredPartitions();
    consumerSettings.MaxCount = 0;
    consumerSettings.MaxSize = 10 << 20;
    consumerSettings.Unpack = true;
    consumerSettings.MaxUncommittedCount = 0;

    if (options.GetSkipLog()) {
        consumerSettings.ReadTimestampMs = TInstant::Now().MilliSeconds() - 60 * 1000;
    } else {
        consumerSettings.ReadTimestampMs = 0;
    }

    TIntrusivePtr<ILogger> logger = MakeIntrusive<NPersQueue::TCerrLogger>(static_cast<int>(options.GetLogPriority()));
    auto alias = options.GetServerTvmId();
    consumerSettings.CredentialsProvider = CreateTVMCredentialsProvider(tvmKeyManager.GetTvmClient(), logger, alias);

    TMaybe<char> splitter = options.GetNoSplitter() ? Nothing() : TMaybe<char>{'\n'};
    return MakeHolder<TLogbrokerPuller>(pqSettings, consumerSettings, logger, commonLabels, splitter);
}
