#pragma once

#include "tvm.h"
#include "lbwrapper.h"

#include <crypta/graph/soup/config/proto/bigb.pb.h>
#include <crypta/graph/rtdi-rt/decryptor/decryptor.h>
#include <crypta/lib/native/logbroker/logbroker.h>
#include <library/cpp/json/writer/json_value.h>
#include <util/datetime/base.h>
#include <library/cpp/deprecated/atomic/atomic.h>
#include <util/thread/pool.h>
#include <util/generic/strbuf.h>
#include <contrib/libs/re2/re2/re2.h>

class TFilteredReader {
private:
    TFilteredReaderOptions Options;
    TAtomic Running;
    TTvmKeyManager TvmKeyManager;
    THolder<NCryptaLogbroker::TLogbrokerPuller> LogbrokerPullerHandle;
    THolder<NCrypta::NGraph::TDecryptor> DecryptorPtr;
    TVector<THolder<re2::RE2>> FilterExpressions;
    TThreadPool SenderQueue;

    void CallBack(const TStringBuf);
    bool IsMatched(const TString&);
    void DecryptAndPrint(const TString);

    inline bool IsRunning() const {
        return AtomicGet(Running);
    }

public:
    TFilteredReader(const TFilteredReaderOptions& options);
    void Start();
    void Stop();
};
