#pragma once

#include <library/cpp/tvmauth/client/facade.h>
#include <crypta/utils/socket_filter/proto/options.pb.h>
#include <util/string/cast.h>
#include <memory>

class TTvmKeyManager {
private:
    TFilteredReaderOptions::TTvmOptions Options;
    std::shared_ptr<NTvmAuth::TTvmClient> TvmClient;

public:
    TTvmKeyManager(TFilteredReaderOptions::TTvmOptions options, TVector<TString> serviceIds)
        : Options(std::move(options))
    {
        NTvmAuth::NTvmApi::TClientSettings settings;
        NTvmAuth::NTvmApi::TClientSettings::TDstMap dstMap;

        settings.SetSelfTvmId(FromString<ui32>(Options.GetClientTvmId()));
        settings.EnableServiceTicketChecking();
        settings.EnableUserTicketChecking(NTvmAuth::EBlackboxEnv::ProdYateam);

        for (const auto& serviceId : serviceIds) {
            dstMap[serviceId] = FromString<ui32>(serviceId);
        }

        settings.EnableServiceTicketsFetchOptions(Options.GetClientTvmSecret(), std::move(dstMap));
        NTvmAuth::TLoggerPtr logger = MakeIntrusive<NTvmAuth::TCerrLogger>(Options.GetTvmLogPriority());
        TvmClient = std::make_shared<NTvmAuth::TTvmClient>(settings, logger);
    }

    TString GetTicketFor(const TString serviceId) const {
        return TvmClient->GetServiceTicketFor(serviceId);
    }

    TString GetTicketFor(const ui32 serviceId) const {
        return TvmClient->GetServiceTicketFor(ToString(serviceId));
    }

    std::shared_ptr<NTvmAuth::TTvmClient> GetTvmClient() const {
        return TvmClient;
    }

    TString GetClientAlias() const {
        return Options.GetClientAlias();
    }
};
