import argparse

from crypta.lib.python import templater


def init_args():
    parser = argparse.ArgumentParser(formatter_class=argparse.ArgumentDefaultsHelpFormatter)
    parser.add_argument("--input", required=True, help="Input file")
    parser.add_argument("--output", default="", help="Output file. If not given, stdout is used.")
    parser.add_argument("--strict", action="store_true", help="Enable strict mode in rendering")
    parser.add_argument("vars", nargs="*", help="Template variables following format 'key=value'")

    return parser.parse_args()


def main():
    args = init_args()

    with open(args.input) as f:
        template = f.read()

    rendered_template = templater.render_template(template, templater.split_vars(args.vars), strict=args.strict)

    if args.output:
        with open(args.output, "w") as out:
            out.write(rendered_template)
    else:
        print(rendered_template)

if __name__ == "__main__":
    main()
