import re


HOST_POSITION = 3


def parse_push_client_output(raw_log):
    push_client_output_regexps = {
        'partition': re.compile(r'partition: (\d+)'),
        'topic': re.compile(r'topic: (\S+),'),
        'queue_host': re.compile(r'host: (\S+)'),
        'status': re.compile(r'status: (\S+)'),
    }

    parts = raw_log.split(' ', HOST_POSITION+1)
    push_client_run_data = {'sender_host': parts[HOST_POSITION], "raw": raw_log}
    for name, regexp in push_client_output_regexps.iteritems():
        match = re.search(regexp, raw_log)
        if match:
            push_client_run_data[name] = match.group(1)
    return push_client_run_data
