import argparse

from crypta.lib.python import (
    cmd,
    yaml_config
)


def main():
    parser = argparse.ArgumentParser(description="Run upload_to_logbroker")
    parser.add_argument("--bin", required=True)
    parser.add_argument("--config", required=True)
    args = parser.parse_args()

    config = yaml_config.load(args.config)

    cmd_line = cmd.get_cmd_line(args.bin, config)

    cmd.check_call_in_current_env(cmd_line)
