import yt.wrapper as yt


METRICS = [
    "demand_ratio",
    "operations_counts",
    "usage_ratio"
]


def get_input_table(yt_client, table_path, row_range):
    row_lower_bound, row_upper_bound = get_row_bounds(yt_client, table_path, row_range)
    return yt.TablePath(table_path, start_index=row_lower_bound, end_index=row_upper_bound)


def get_metrics_from_row(row):
    return [("{}.{}".format(row["pool"], metric), row[metric], row["timestamp"]) for metric in METRICS]


def get_row_bounds(yt_client, table_path, row_range):
    row_upper_bound = yt_client.get(yt.ypath_join(table_path, "@row_count"))
    row_lower_bound = row_upper_bound - row_range
    return row_lower_bound, row_upper_bound
