import datetime

from crypta.lib.python.spine.consts.yt_proxy import YtProxy
from crypta.lib.python.spine.juggler import (
    consts,
    juggler_check_generator,
)


def get_registry():
    deploy_group = "crypta@stage=crypta-yt-stats-production"

    juggler = juggler_check_generator.CryptaYtCheckGenerator(
        tags=["crypta-yt"],
        warn_limit=0,
        crit_limit=1,
        child_group=deploy_group,
        child_group_type=consts.GroupType.deploy,
        escalation=False,
    )

    juggler.icmpping().add_phone_escalation()
    juggler.graphite_client().set_warn_limit(1).add_yt_dependencies([YtProxy.hahn])
    juggler.periodic_task("crypta_yt_stats", crit_time=datetime.timedelta(hours=4)).add_yt_dependencies([YtProxy.hahn])

    return juggler
