import logging
import os

import flask
from flask import request
from google.protobuf.json_format import MessageToJson
import requests
import uuid

from yabs.server.proto.debug_response.debug_pb2 import TDebugResponse


app = flask.Flask(__name__)


def create_debug_response_url(hitlogid):
    template = "http://rtb-adexchange.yandex.net/v1/keys/debug_response_{hitlogid}_meta"
    return template.format(hitlogid=hitlogid)


@app.route('/debug')
def get_debug_info():
    hitlogid = request.args.get('hit-log-id', None, type=int)

    if not hitlogid:
        return "hit-log-id required", 400

    response = requests.get(create_debug_response_url(hitlogid))

    if response.status_code == 404:
        return "not found", 404

    proto_response = TDebugResponse()
    proto_response.ParseFromString(response.content)
    return MessageToJson(proto_response, including_default_value_fields=True)


def create_statmx_response_url(hitlogid):
    template = "https://bsinfo.yandex.ru/why_this_ad/api/get_stat_mx_features_log/{hitlogid}"
    return template.format(hitlogid=hitlogid)


@app.route('/statmx')
def get_statmx():
    hitlogid = request.args.get('hit-log-id', None, type=int)

    if not hitlogid:
        return "hit-log-id required", 400

    response = requests.get(create_statmx_response_url(hitlogid))

    if response.status_code == 404:
        return "not found", 404

    return response.content, 200


@app.route('/sbs')
def get_sbs():
    return {
        'id': uuid.uuid4(),
        'candidates': [
            72057605061909174,
            72057604795119401,
        ],
    }


@app.route('/sbs/<sbs_id>', methods=['POST'])
def store_sbs(sbs_id):
    return "OK"


def main():
    logging.basicConfig(format='%(asctime)-15s %(message)s',
                        level=logging.INFO)
    app.run(host='::', port=os.environ.get('PORT', 80), debug=False)
