import os
import sys
import logging

from urllib.parse import quote_plus
from flask import (
    Flask, request, render_template_string
)

from uuid import uuid4

import library.python.resource as rs


logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
handler = logging.StreamHandler(sys.stdout)
handler.setLevel(logging.DEBUG)
formatter = logging.Formatter('%(asctime)s - %(name)s - %(levelname)s - %(message)s')
handler.setFormatter(formatter)
logger.addHandler(handler)

APP_PORT = int(os.environ.get('APP_PORT') or 9999)

APP = Flask('capture')


TITLES = {
    'capture1.grab.crypta.yandex.ru': 'captureonezero captureoneone captureonetwo',
    'capture2.grab.crypta.yandex.ru': 'capturetwozero capturetwoone capturetwotwo',
    'capture3.grab.crypta.yandex.ru': 'capturethreezero capturethreeone capturethreetwo',
    'capture4.grab.crypta.yandex.ru': 'capturefourzero capturefourone capturefourtwo',
    'capture5.grab.crypta.yandex.ru': 'capturefivezero capturefiveone capturefivetwo',
    'capture6.grab.crypta.yandex.ru': 'capturesixzero capturesixone capturesixtwo',
    'capture7.grab.crypta.yandex.ru': 'capturesevenzero capturesevenone captureseventwo',
    'capture8.grab.crypta.yandex.ru': 'captureeightzero captureeightone captureeighttwo',
    'capture9.grab.crypta.yandex.ru': 'captureninezero capturenineone captureninetwo',
    'capture10.grab.crypta.yandex.ru': 'capturetenzero capturetenone capturetentwo',
    'capture11.grab.crypta.yandex.ru': 'captureelevenzero captureelevenone captureeleventwo',
    'capture12.grab.crypta.yandex.ru': 'capturetwelvezero capturetwelveone capturetwelvetwo',
    'capture13.grab.crypta.yandex.ru': 'capturethirteenzero capturethirteenone capturethirteentwo',

    'capture14.grab.crypta.yandex.ru': 'capturefourteenzero capturefourteenone capturefourteentwo',
    'capture15.grab.crypta.yandex.ru': 'capturefifteenzero capturefifteenone capturefifteentwo',
    'capture16.grab.crypta.yandex.ru': 'capturesixteenzero capturesixteenone capturesixteentwo',
    'capture17.grab.crypta.yandex.ru': 'captureseventeenzero captureseventeenone captureseventeentwo',
    'capture18.grab.crypta.yandex.ru': 'captureeighteenzero captureeighteenone captureeighteentwo',
    'capture19.grab.crypta.yandex.ru': 'capturenineteenzero capturenineteenone capturenineteentwo',
    'capture20.grab.crypta.yandex.ru': 'capturetwentyzero capturetwentyone capturetwentytwo',
    'capture21.grab.crypta.yandex.ru': 'capturetwentyonezero capturetwentyoneone capturetwentyonetwo',
    'capture22.grab.crypta.yandex.ru': 'capturetwentytwozero capturetwentytwoone capturetwentytwotwo',
    'capture23.grab.crypta.yandex.ru': 'capturetwentythreezero capturetwentythreeone capturetwentythreetwo',
    'capture24.grab.crypta.yandex.ru': 'capturetwentyfourzero capturetwentyfourone capturetwentyfourtwo',
    'capture25.grab.crypta.yandex.ru': 'capturetwentyfivezero capturetwentyfiveone capturetwentyfivetwo',
    'capture26.grab.crypta.yandex.ru': 'capturetwentysixzero capturetwentysixone capturetwentysixtwo',

    'localhost:%d' % APP_PORT: 'running on localhost'
}

NONCE = {'value': None}


@APP.route('/')
def start():
    host = request.headers['Host']
    logger.info("Request on %s fired" % host)
    NONCE['value'] = str(uuid4())

    return APP.response_class(
        response=render_template_string(rs.find('/mc.html').decode('utf-8'), title=TITLES[host], nonce=NONCE['value']),
        status=200
    )


@APP.after_request
def patch_headers(response):
    # See actual CSP at https://wiki.yandex-team.ru/product-security/csp/metrika/

    host = request.headers['Host']
    yandexuid = request.cookies.get('yandexuid') or ''
    login = request.cookies.get('yandex_login') or ''

    script_src_domains = "mc.yandex.ru mc.yandex.az mc.yandex.by mc.yandex.co.il mc.yandex.com mc.yandex.com.am "\
                         "mc.yandex.com.ge mc.yandex.com.tr mc.yandex.ee mc.yandex.fr mc.yandex.kg mc.yandex.kz "\
                         "mc.yandex.lt mc.yandex.lv mc.yandex.md mc.yandex.ru mc.yandex.tj mc.yandex.tm mc.yandex.ua "\
                         "mc.yandex.uz mc.webvisor.com mc.webvisor.org yastatic.net;"

    img_src_domains = "yastatic.net mc.yandex.az mc.yandex.by mc.yandex.co.il mc.yandex.com mc.yandex.com.am "\
                      "mc.yandex.com.ge mc.yandex.com.tr mc.yandex.ee mc.yandex.fr mc.yandex.kg mc.yandex.kz "\
                      "mc.yandex.lt mc.yandex.lv mc.yandex.md mc.yandex.ru mc.yandex.tj mc.yandex.tm mc.yandex.ua "\
                      "mc.yandex.uz mc.webvisor.com mc.webvisor.org;"

    connect_src_domains = "mc.yandex.az mc.yandex.by mc.yandex.co.il mc.yandex.com mc.yandex.com.am mc.yandex.com.ge "\
                          "mc.yandex.com.tr mc.yandex.ee mc.yandex.fr mc.yandex.kg mc.yandex.kz mc.yandex.lt "\
                          "mc.yandex.lv mc.yandex.md mc.yandex.ru mc.yandex.tj mc.yandex.tm mc.yandex.ua mc.yandex.uz "\
                          "mc.webvisor.com mc.webvisor.org;"

    response.headers['Server'] = 'nginx'
    response.headers['Content-Security-Policy'] = "default-src 'none';" + \
                                                  "script-src 'unsafe-inline' 'nonce-%s' %s" %\
                                                  (NONCE['value'], script_src_domains) + \
                                                  "img-src 'self' " + img_src_domains + \
                                                  "connect-src " + connect_src_domains + \
                                                  "report-uri https://csp.yandex.net/csp?from=" + quote_plus(host) + "&project=" \
                                                  "crypta&yandex_login=" + quote_plus(login) + "&yandexuid=%s;" % quote_plus(yandexuid)
    response.headers['X-Frame-Options'] = "SAMEORIGIN"
    response.headers['X-XSS-Protection'] = "1; mode=block"
    response.headers['X-Content-Type-Options'] = "nosniff"

    return response


@APP.route('/favicon.ico')
def favicon():
    return APP.response_class(response='', status=200)


@APP.route('/health')
def health():
    return APP.response_class(response='OK', status=200)


def main():
    APP.logger.info('Starting APP')
    APP.run(host='::', port=int(os.environ.get('PORT', APP_PORT)), debug=False)
