import geobase6
import re
from flask import Flask, request


privateReplayIspName = "icloud private relay"


def createApp(name, geobasePath):
    app = Flask(name)
    app.lookup = geobase6.Lookup(geobasePath)

    @app.route("/")
    def index():
        return "OK", 200

    @app.route("/check_relay")
    def do_check_replay():
        yandexIp = request.headers.get('X-Forwarded-For', "NO YANDEX IP")
        yandexIspName = "NO YANDEX ISP"
        siteIp = request.args.get("ip", "NO SITE IP")
        siteIspName = "NO SITE ISP"

        if not re.match("^[0-9a-fA-F:.]{7,40}$", siteIp):
            siteIp = "NO SITE IP"

        try:
            yandexIspName = app.lookup.get_ip_traits(yandexIp)["isp_name"]
        except Exception:
            pass

        try:
            siteIspName = app.lookup.get_ip_traits(siteIp)["isp_name"]
        except Exception:
            pass

        if yandexIspName == privateReplayIspName:
            msgPrefix = "ISRELAY"
        else:
            msgPrefix = "NERELAY"

        eq = siteIp == yandexIp and "==" or "!="

        return "{} {} ({}) {} {} ({})".format(msgPrefix, yandexIp, yandexIspName, eq, siteIp, siteIspName), 200

    @app.after_request
    def set_acao(response):
        origin = request.headers.get("Origin", None)
        if origin:
            response.headers['Access-Control-Allow-Origin'] = origin
        response.headers['Access-Control-Allow-Credentials'] = 'true'

        return response

    return app
