# -*- coding: utf-8 -*-
# from __future__ import unicode_literals
import json
import logging
import flask
import datetime
from hashlib import sha256
from flask import request, jsonify
from flask_mail import Mail, Message as MailMessage
import numpy as np
import os
import re
import time
import requests
from sqlalchemy import Column, DateTime, String, Integer, Boolean, update
from threading import Thread
import urllib

import crypta.web.dating.back.backend as backend
import crypta.web.dating.back.db as db


werklog = logging.getLogger('werkzeug')
werklog.setLevel(logging.ERROR)

MAX_CHATS_PER_24H = 15
ONLINE_WINDOW = 15
FRONT_DOMAIN = os.environ.get('DATING_URL', 'dating.yandex-team.ru')
service_testers = []

logger = logging.getLogger(__name__)

app = flask.Flask(__name__)
app.config['MAIL_SERVER'] = 'smtp.yandex-team.ru'
app.config['MAIL_PORT'] = 465
app.config['MAIL_USE_SSL'] = True
app.config['MAIL_USERNAME'] = 'robot-unicorn'
app.config['MAIL_PASSWORD'] = os.environ.get('ROBOT_PASS')
app.config['MAIL_SUPPRESS_SEND'] = False

mail = Mail(app)

MAIL_SUBJECT_NEW = u'Crypta.Dating - у тебя новый чат!'
MAIL_BODY_EMPTY_NEW = u"""
<p>Привет, {name}!</p>
<p>Только что тебе пришло анонимное сообщение в сервисе <a href=\"""" + FRONT_DOMAIN + u"""/utm_source=mail">Crypta.Dating</a> от <b>{sex}</b> возрастом <b>{age}</b>.</p>
<p>Чтобы увидеть текст и ответить, перейди по <a href=\"""" + FRONT_DOMAIN + u"""/?chats=1&utm_source=mail">ссылке</a>.</p>

<p>Напоминаем, что ты тоже можешь отправить анонимное сообщение самым близким коллегам.</p>

<p>Отличного настроения и хорошего дня!</p>

<p>P.S. Подобные уведомления будут приходить только если кто-то новый захотел с тобой общаться, а не на каждое сообщение.</p>

<p>С любовью,<br>
<a href="https://wiki.yandex-team.ru/crypta/">Команда Крипты</a></p>
"""

MAIL_SUBJECT_UNREAD = u'Crypta.Dating - у тебя непрочитанные сообщения!'
MAIL_BODY_UNREAD_MESSAGES = u"""
<p>Привет, {name}!</p>
<p>У тебя есть непрочитанные сообщения.</p>
<p>Чтобы увидеть текст и ответить, перейди по <a href=\"""" + FRONT_DOMAIN + u"""/?chats=1&utm_source=mail">ссылке</a>.</p>

<p>Отличного настроения и хорошего дня!</p>

<p>P.S. Ты всегда можешь отписаться от подобных уведомлений - для этого отключи опцию отправки писем о непрочитанных сообщениях в сервисе.</p>

<p>С любовью,<br>
<a href="https://wiki.yandex-team.ru/crypta/">Команда Крипты</a>
"""

BLACKBOX_URL = os.environ.get('BLACKBOX_URL', 'http://pass-test.yandex.ru/blackbox')


class Lovers(db.Base):
    __tablename__ = 'users_table'
    _id = Column(Integer, primary_key=True)
    _login = Column(String)
    _online_ts = Column(DateTime)
    _status = Column(Boolean)
    _notifications_enabled = Column(Boolean, default=False)


class Chat(db.Base):
    __tablename__ = 'dating_chats_all'
    _id = Column(Integer, primary_key=True)
    _from = Column(String)
    _to = Column(String)
    _timestamp = Column(DateTime)
    _removed = Column(Boolean, default=False)
    _was_notifed = Column(Boolean, default=True)


class Message(db.Base):
    __tablename__ = 'dating_messages'
    _id = Column(Integer, primary_key=True)
    _chatid = Column(Integer)
    _from = Column(String)
    _text = Column(String)
    _readed = Column(Boolean, default=False)
    _timestamp = Column(DateTime)


def set_online(login):
    try:
        profile = session.query(Lovers).filter(Lovers._login == login).first()
        if profile:
            profile._online_ts = datetime.datetime.now()
        else:
            session.add(Lovers(
                _login=login,
                _status=False,
                _online_ts=datetime.datetime.now()
            ))
        session.commit()
    except:
        logger.exception('Failed to set online')
        session.rollback()
    finally:
        session.close()


def last_online(login):
    profile = session.query(Lovers).filter(Lovers._login == login).first()
    if profile:
        return profile._online_ts
    else:
        return datetime.datetime(1970, 1, 1, 0, 0)


def is_online(login):
    return (datetime.datetime.now() - last_online(login)).total_seconds() < ONLINE_WINDOW


def authorized(login, cookies, host, ip, csrf=None, ignore_csrf=False):
    logger.info('Authentificating %s', login)
    if login == 'None':
        return False

    sessionid = cookies.get('Session_id', None)

    if not sessionid:
        return False

    sessionid = urllib.unquote(sessionid)

    if not re.match(r"\A[a-zA-Z0-9_\-\:\.\|]+\Z", sessionid.strip().rstrip(';')):
        return False

    sessionid = urllib.quote(sessionid)
    response = requests.get(
        '%s?method=sessionid&userip=%s&sessionid=%s&format=json&host=%s' % (BLACKBOX_URL, ip, sessionid, host))

    if response.status_code != 200:
        return False

    try:
        response_json = json.loads(response.text)
    except Exception:
        return False

    if 'login' not in response_json:
        return False

    if response_json['login'] != login:
        return False

    if not ignore_csrf and str(csrf) != str(sha256(login + os.environ.get('COOKIE_SECRET')).hexdigest()):
        return False

    set_online(login)

    return True


def extract_cookies(request):
    return {k: v for (k, v) in
            (each.strip().split('=', 1)
             for each in request.headers['Cookie'].split(';')
             if '=' in each)
            }


def set_cors(resp):
    resp.headers['Access-Control-Allow-Methods'] = 'GET,PUT,POST,DELETE,OPTIONS'
    resp.headers['Access-Control-Allow-Origin'] = FRONT_DOMAIN
    resp.headers[
        'Access-Control-Allow-Headers'] = 'Content-Type,Authorization,X-Requested-With,Content-Length,Accept,Origin,'
    resp.headers['Access-Control-Allow-Credentials'] = 'true'


def left_dialogs(login):
    first_day = datetime.datetime.now() - datetime.timedelta(days=1)
    try:
        return MAX_CHATS_PER_24H - session.query(Chat).filter(
            Chat._from == login,
            Chat._timestamp.isnot(None),
            Chat._timestamp > first_day
        ).count() if str(login) not in service_testers else 777  # for testing # azino tri topora
    except:
        session.rollback()
        raise
    finally:
        session.close()


def age_group(age):
    if str(age) == u'unknown':
        return u''
    return age
    if not age.isdigit():
        return age
    age = int(age)
    if age < 18:
        return u'младше 18'
    elif age < 21:
        return u'18-20'
    elif age < 26:
        return u'21-25'
    elif age < 28:
        return u'26-27'
    elif age < 30:
        return u'28-29'
    elif age < 32:
        return u'30-31'
    elif age < 34:
        return u'32-33'
    elif age < 38:
        return u'34-37'
    elif age < 42:
        return u'38-41'
    elif age < 48:
        return u'42-47'
    elif age < 56:
        return u'48-55'
    return u'старше 55'


@app.route('/_cnd_new_dialog', methods=['POST'])
def cnd_new_dialog():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    other = str(request.get_json(force=True).get('other', ''))
    text = str(request.get_json(force=True).get('text', '').encode('utf8'))

    if not text:
        response = jsonify({'message': 'error', 'Error': u'Нельзя отправить пустое сообщение!'})
        response.status_code = 400
        set_cors(response)
        return response

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    if other not in login2index:
        response = jsonify({'message': 'error', 'Error': u'Мы ничего не знаем о таком логине ;(', 'login': other})
    elif login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    elif login == other:
        response = jsonify({'message': 'error', 'Error': u'Нельзя отправлять самому себе!', 'login': other})
    elif left_dialogs(login) <= 0:
        response = jsonify(
            {'message': 'error', 'Error': u'Упс! Вы исчерпали лимит новых чатов на сегодня. Возвращайтесь завтра!',
             'login': login, 'left': left_dialogs(login)})
    else:
        if str(staff[login]['gender']) == u'male':
            sex = u'мужчины'
        elif str(staff[login]['gender']) == u'female':
            sex = u'женщины'
        else:
            sex = u'неизвестного'
        age = age_group(str(staff[login]['age']))
        if not age:
            age = u'N лет'
        msg = MailMessage(
            sender=(u'Крипта', u'robot-unicorn@yandex-team.ru'),
            subject=MAIL_SUBJECT_NEW,
            html=MAIL_BODY_EMPTY_NEW.format(name=staff[other]['name'], age=age, sex=sex),
            recipients=[
                other + '@yandex-team.ru',  # .format(other),
            ],
            bcc=[
                'crypta-dating-valentines@yandex-team.ru'
            ],
        )
        try:
            if not session.query(Chat).filter(Chat._from == login, Chat._to == other).first():
                new_chat = Chat(
                    _from=login,
                    _to=other,
                    _timestamp=datetime.datetime.now()
                )
                session.add(new_chat)
                session.commit()  # fail ;( (we need foreign key, but f**k it)
                session.add(Message(
                    _chatid=new_chat._id,
                    _from=login,
                    _text=text,
                    _timestamp=datetime.datetime.now()
                ))
                session.commit()
            else:
                response = jsonify({'message': 'error', 'Error': u'Вы уже начали диалог с этим пользователем!'})
                set_cors(response)
                return response
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error', 'Error': u'Что-то пошло не так ;('})
        else:
            mail.send(msg)
            response = jsonify({'message': 'ok', 'chatid': new_chat._id})
        finally:
            session.close()

    set_cors(response)
    return response


@app.route('/_cnd_dialog_list', methods=['POST'])
def cnd_dialog_list():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    else:
        try:
            dialogs = session.query(Chat).filter((Chat._from == login) | (Chat._to == login)).filter(
                Chat._removed.is_(False)).all()
            dialog_dicts = []

            for dialog in dialogs:
                dialog_dict = {}
                if dialog._from == login:
                    target = dialog._to
                    dialog_dict['name'] = staff.get(target, {}).get('name', '')
                    dialog_dict['login'] = target
                    dialog_dict['age'] = str(staff.get(target, {}).get('age', ''))
                    if dialog_dict['age'] == u'unknown':
                        dialog_dict['age'] = u''
                else:
                    target = dialog._from
                    dialog_dict['name'] = "Аркадия" if str(
                        staff.get(target, {}).get('gender', '')) == u'female' else "Аркадий"
                    dialog_dict['login'] = "anonym"
                    dialog_dict['age'] = age_group(str(staff.get(target, {}).get('age', '')))
                dialog_dict['isOnline'] = is_online(target)
                dialog_dict['sex'] = staff.get(target, {}).get('gender', '')
                dialog_dict['unreaded_messages'] = session.query(Message).filter(Message._chatid == dialog._id,
                                                                                 Message._readed.is_(False),
                                                                                 Message._from != login).count()
                ts_obj = session.query(Message).filter(Message._chatid == dialog._id).order_by(
                    Message._id.desc()).first()
                dialog_dict['ts'] = ts_obj._timestamp if ts_obj else datetime.datetime.now()
                dialog_dict['chatid'] = dialog._id
                dialog_dicts.append(dialog_dict)

            response = jsonify({'dialogs': sorted(dialog_dicts, key=lambda x: x['ts'], reverse=True)})
        except Exception as e:
            response = jsonify({'message': 'error', 'Error': u'Что-то пошло не так ;('})
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
        finally:
            session.close()

    set_cors(response)
    return response


@app.route('/_cnd_new_message', methods=['POST'])
def cnd_new_message():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    chatid = str(request.get_json(force=True).get('chatid', ''))
    text = str(request.get_json(force=True).get('text', '').encode('utf8'))

    if not chatid or not chatid.isdigit():
        response = jsonify({'Error': 'invalid chatid val'})
        response.status_code = 400
        set_cors(response)
        return response

    if not text:
        response = jsonify({'Error': 'You must specify text of message'})
        response.status_code = 400
        set_cors(response)
        return response

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    chatid = int(chatid)

    dialogobj = session.query(Chat).filter(Chat._id == chatid, Chat._removed.is_(False)).filter(
        (Chat._from == login) | (Chat._to == login)).first()

    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    elif not dialogobj:
        response = jsonify({'Error': 'This dialog not exist!', 'login': login, 'chatid': chatid})
    else:
        try:
            dialogobj._was_notifed = False
            session.add(Message(
                _chatid=chatid,
                _from=login,
                _text=text,
                _timestamp=datetime.datetime.now()
            ))
            session.commit()
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error'})
        else:
            response = jsonify({'message': 'ok'})
        finally:
            session.close()

    set_cors(response)
    return response


@app.route('/_cnd_messages', methods=['POST'])
def cnd_messages():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    chatid = str(request.get_json(force=True).get('chatid', ''))
    update = int(str(request.get_json(force=True).get('update', '0')))

    if not chatid or not chatid.isdigit():
        response = jsonify({'Error': 'invalid chatid val'})
        response.status_code = 400
        set_cors(response)
        return response

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    chatid = int(chatid)

    dialogobj = session.query(Chat).filter(Chat._id == chatid, Chat._removed.is_(False)).filter(
        (Chat._from == login) | (Chat._to == login)).first()

    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    elif not dialogobj:
        response = jsonify({'Error': 'This dialog not exist!', 'login': login, 'chatid': chatid})
    else:
        try:
            query = session.query(Message).filter(Message._chatid == chatid)
            if update:
                query = query.filter(Message._from != login, Message._readed.is_(False))
            messages = query.order_by(Message._timestamp).all()
            message_dicts = []
            for message in messages:
                if message._from != login:
                    message._readed = True
                message_dicts.append({"mine": (message._from == login), "text": message._text, "ts": message._timestamp,
                                      "isRead": message._readed})
            session.commit()
            chat_obj = session.query(Chat).filter(Chat._id == chatid).first()
            isonl = is_online(chat_obj._from if chat_obj._to == login else chat_obj._to) if chat_obj else False
            response = jsonify({'messages': message_dicts, 'isOnline': isonl})
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error'})
        finally:
            session.close()

    set_cors(response)
    return response


@app.route('/_cnd_data_friends', methods=['POST'])
def cnd_data_friends():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    gender = str(request.get_json(force=True).get('sex', 'ANY'))
    age = str(request.get_json(force=True).get('age', 'ANY'))
    martial = str(request.get_json(force=True).get('martial', 'ANY'))
    city = str(request.get_json(force=True).get('city', 'ANY'))
    lover = str(request.get_json(force=True).get('lover', 'ANY'))
    online = 'ANY'  # str(request.get_json(force=True).get('online', 'ANY'))

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    if login not in login2index:
        response = {'Error': 'Unknown source login', 'login': login}
    else:
        filter_vector = get_filtering_vector(gender, age, martial, city)
        try:
            all_lovers = [r._login for r in session.query(Lovers).filter(Lovers._status.is_(True)).all()]
            onliners = [r._login for r in session.query(Lovers).filter(
                (Lovers._online_ts + datetime.timedelta(seconds=ONLINE_WINDOW)) > datetime.datetime.now()).all()]
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            all_lovers = []
        finally:
            session.close()
        friends = backend.get_friends(login, login2index, index2login,
                                      distances, indeces, filter_vector,
                                      lover, all_lovers, online, onliners, blacklist)

        for friend in friends:
            friend['name'] = staff[friend['login']]['name']
            friend['sex'] = staff[friend['login']]['gender']
            friend['age'] = str(staff[friend['login']]['age'])
            friend['position'] = staff[friend['login']]['position']
            try:
                # friend['isOnline'] = is_online(chat_obj._from if chat_obj._to == login else chat_obj._to)
                friend['isOnline'] = False
            except:
                session.rollback()
                friend['isOnline'] = False
            finally:
                session.close()

        response = {'friends': friends}

    response = jsonify(response)
    set_cors(response)
    return response


@app.route('/_cnd_change_status', methods=['POST'])
def cnd_change_status():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))

    status = int(str(request.get_json(force=True).get('lover', '-1')))
    is_notification_enabled = int(str(request.get_json(force=True).get('is_notification_enabled', '-1')))
    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response
    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    else:
        try:
            love_obj = session.query(Lovers).filter(Lovers._login == login).first()
            if love_obj:
                if status != -1:
                    love_obj._status = bool(status)
                if is_notification_enabled != -1:
                    love_obj._notifications_enabled = bool(is_notification_enabled)
            else:
                if status == -1:
                    status = 0
                session.add(Lovers(
                    _login=login,
                    _status=bool(status),
                    _online_ts=datetime.datetime.now(),
                    _notifications_enabled=True
                ))
            session.commit()
            response = jsonify({'message': 'ok'})
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error'})
        finally:
            session.close()
    set_cors(response)
    return response


@app.route('/_cnd_get_status', methods=['POST'])
def cnd_get_status():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response
    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    else:
        try:
            all_lovers = session.query(Lovers).filter(Lovers._status.is_(True)).all()
            love_obj = session.query(Lovers).filter(Lovers._login == login).first()
            total_online = session.query(Lovers).filter(
                (Lovers._online_ts + datetime.timedelta(seconds=ONLINE_WINDOW)) > datetime.datetime.now()).count()
            answer = {'all': len(all_lovers), u'male': 0, u'female': 0,
                      u'total_online': total_online}  # defaultdict is better
            for obj in all_lovers:
                answer[str(staff[obj._login].get('gender', u'male'))] += 1
            if love_obj:
                answer['status'] = int(love_obj._status)
            else:
                answer['status'] = 0
            answer['unreaded_dialogs'] = 0
            dialogs = session.query(Chat).filter((Chat._from == login) | (Chat._to == login)).filter(
                Chat._removed.is_(False)).all()
            for dialog in dialogs:
                if session.query(Message).filter(Message._chatid == dialog._id, Message._readed.is_(False),
                                                 Message._from != login).count():
                    answer['unreaded_dialogs'] += 1
            answer['is_notification_enabled'] = love_obj._notifications_enabled
            response = jsonify(answer)
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error'})
        finally:
            session.close()
    set_cors(response)
    return response


@app.route('/_cnd_ban_chat', methods=['POST'])
def cnd_ban_chat():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    chatid = str(request.get_json(force=True).get('chatid', ''))
    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    chatid = int(chatid)

    dialogobj = session.query(Chat).filter(Chat._id == chatid, Chat._removed.is_(False)).filter(
        (Chat._from == login) | (Chat._to == login)).first()

    if login not in login2index:
        response = jsonify({'Error': 'Unknown source login', 'login': login})
    elif not dialogobj:
        response = jsonify({'Error': 'This dialog not exist!', 'login': login, 'chatid': chatid})
    else:
        try:
            dialogobj._removed = True
            session.commit()
        except Exception as e:
            session.rollback()
            logger.info('%s: %s - %s - %s', type(e), e, e.message, e.args)
            response = jsonify({'message': 'error'})
        finally:
            session.close()
    set_cors(response)
    return response


@app.route('/_cnd_data_rank', methods=['POST'])
def cnd_data_rank():
    csrf = str(request.get_json(force=True).get('csrf', ''))
    login = str(request.get_json(force=True).get('login', ''))
    other = str(request.get_json(force=True).get('other', 'imperator'))

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, csrf=csrf):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    if other not in login2index:
        response = {'Error': 'Unknown other login', 'login': other}
    elif login not in login2index:
        response = {'Error': 'Unknown source login', 'login': login}
    else:
        rank = backend.rank_login_in_other_list(login, other, indeces, login2index)
        response = {'rank': str(rank)}
    response = jsonify(response)
    set_cors(response)
    return response


@app.route('/_cnd_get_csrf', methods=['POST'])
def cnd_get_csrf():
    login = str(request.get_json(force=True).get('login', ''))

    if not authorized(login, extract_cookies(request), 'yandex-team.ru', request.remote_addr, ignore_csrf=True):
        response = jsonify({'message': 'Not authorized'})
        response.status_code = 403
        set_cors(response)
        return response

    if login not in login2index:
        response = {'Error': 'Unknown source login', 'login': login}
    else:
        csrf = sha256(login + os.environ.get('COOKIE_SECRET')).hexdigest()
        response = {'csrf': str(csrf)}
    response = jsonify(response)
    set_cors(response)
    return response


def get_filtering_vector(gender, age, martial, city):
    answer = np.ones(len(index2login), dtype=bool)
    if gender != 'ANY':
        answer &= (genders == gender)
    if age != 'ANY':
        answer &= (ages == age)
    if martial != 'ANY':
        answer &= (martials == martial)
    if city != 'ANY':
        answer &= (cities == city)
    return answer


# @app.before_first_request
def setup():
    logger.info("Start getting info from staff and new vectors")
    staff_ = backend.get_staff_data()
    logger.info('Staff logins downloaded: %s' % staff_.keys())
    login2vec, blacklist_ = backend.get_login2vec(set(staff_.keys()))
    login2index_, index2login_, distances_, indeces_ = backend.get_neighbours_data(
        login2vec
    )
    genders_, ages_, martials_, cities_ = backend.get_staff_filtering_vectors(
        staff_, index2login_
    )
    global staff, login2index, index2login, distances, indeces, genders, ages, martials, cities, blacklist
    staff, login2index, index2login, distances, indeces, genders, ages, martials, cities, blacklist = \
            staff_, login2index_, index2login_, distances_, indeces_, genders_, ages_, martials_, cities_, blacklist_


def send_unread_messages():
    from_unreaded_chats_logins = session.query(Lovers._login).join(Chat, Chat._from == Lovers._login). \
        join(Message, Message._chatid == Chat._id) \
        .filter(Lovers._notifications_enabled.is_(True)) \
        .filter(Chat._was_notifed.is_(False)) \
        .filter(Message._readed.is_(False)) \
        .filter(Message._from != Lovers._login)
    to_unreaded_chats_logins = session.query(Lovers._login).join(Chat, Chat._to == Lovers._login). \
        join(Message, Message._chatid == Chat._id) \
        .filter(Lovers._notifications_enabled.is_(True)) \
        .filter(Chat._was_notifed.is_(False)) \
        .filter(Message._readed.is_(False)) \
        .filter(Message._from != Lovers._login)

    unread_chat_logins = from_unreaded_chats_logins.union(to_unreaded_chats_logins)
    unread_logins = unread_chat_logins.all()
    unread_logins = list(set([row[0] for row in unread_logins]))
    stmt = update(Chat).values(_was_notifed=True)
    session.execute(stmt)
    session.commit()
    with app.app_context():
        for login in unread_logins:
            try:
                msg = MailMessage(
                    sender=(u'Крипта', u'robot-unicorn@yandex-team.ru'),
                    subject=MAIL_SUBJECT_UNREAD,
                    html=MAIL_BODY_UNREAD_MESSAGES.format(name=staff[login]['name']),
                    recipients=[
                        login + '@yandex-team.ru',  # .format(other),
                    ],
                    bcc=[
                        'crypta-dating-valentines@yandex-team.ru'
                    ],
                )

                mail.send(msg)
            except:
                time.sleep(1)


def regular_thread():
    day_seconds = 60 * 60 * 24
    while True:
        delay = day_seconds - (int(time.time()) % day_seconds)
        logger.info("Sleeping for %i seconds", delay)
        time.sleep(delay)
        try:
            setup()
        except :
            pass
        finally:
            time.sleep(5)


def unread_messages_sender_thread():
    day_seconds = 60 * 60 * 24
    while True:
        delay = day_seconds - (int(time.time()) % day_seconds)
        logger.info("MESSSAGE SENEDER Sleeping for %i seconds", delay)
        time.sleep(delay)
        try:
            send_unread_messages()
        except:
            pass
        finally:
            time.sleep(5)


def main():
    global session
    global engine
    session, engine = db.get_session('db_postcards.db')

    logging.basicConfig(format='%(asctime)-15s %(message)s',
                        level=logging.INFO)
    setup()

    send_unread_messages()
    thr_sender = Thread(target=unread_messages_sender_thread)
    thr_sender.start()
    app.run(host='::', port=os.environ.get('PORT', 80), debug=False)
