from yql.api.v1.client import YqlClient

query = """
USE hahn;

$now = CurrentUtcDatetime();
$three_days_ago = DateTime::ToDate($now - DateTime::IntervalFromDays(3));
$seventeen_days_ago = DateTime::ToDate($now - DateTime::IntervalFromDays(17));

PRAGMA yt.InferSchema;
$login_yandexuid_visits = (
    SELECT
    yandexuid,
    visit_number.0 AS login,
    visit_number.1 AS visits
    FROM (
        SELECT
            vectors.yandexuid AS yandexuid,
            login,
            Yson::ConvertToUint64Dict(CAST(conflicts AS Yson)) AS visits_number
        FROM RANGE('//home/crypta/production/state/radius/metrics', $seventeen_days_ago, $three_days_ago, 'yuid_rlogin/yuid_rlogin_final_stable') AS radius
        INNER JOIN [//home/crypta/production/profiles/export/vectors/yandexuid_vectors_monthly] AS vectors
        ON CAST(radius.yuid AS Uint64) == vectors.yandexuid
        WHERE vectors.days_active IS NOT NULL
    )
    FLATTEN BY visits_number AS visit_number
    ORDER BY login
);
PRAGMA yt.InferSchema = '0';

$max_visits = (
    SELECT login, MAX(visits) AS max_visits
    FROM $login_yandexuid_visits
    GROUP BY login
);

$main_yandexuids_for_logins = (
    SELECT max_visits_table.login AS login, SOME(yandexuid) AS yandexuid
    FROM $login_yandexuid_visits AS logins_table
    INNER JOIN $max_visits AS max_visits_table
    USING (login)
    WHERE max_visits_table.max_visits == logins_table.visits
    GROUP BY max_visits_table.login
    ORDER BY yandexuid
);

INSERT INTO [//home/crypta/production/profiles/cnd/main_yandexuids_for_logins] WITH TRUNCATE
SELECT *
FROM $main_yandexuids_for_logins;

INSERT INTO [//home/crypta/production/profiles/cnd/login2vec] WITH TRUNCATE
SELECT
    login_to_yandexuid.yandexuid AS yandexuid,
    login,
    vector
FROM $main_yandexuids_for_logins AS login_to_yandexuid
INNER JOIN [//home/crypta/production/profiles/export/vectors/yandexuid_vectors_monthly] AS yandexuid2vec
USING (yandexuid)
ORDER BY login;
"""


def main():
    client = YqlClient(db='hahn')
    request = client.query(query)
    request.run()
    request.get_results()


if __name__ == "__main__":
    main()
