import React, { Component } from "react";
import "./App.css";
import Select from "react-islands/components/Select";
import Item from "react-islands/components/Item";
import Spinner from "react-islands/components/Spinner";
import _ from "lodash";
import FontAwesome from "react-fontawesome";
import cookie from "react-cookie";
import classNames from "classnames";
import { MALE_ANONYMOUS_NAMES, FEMALE_ANONYMOUS_NAMES } from "./names";
import check from "./check.svg";
import dcheck from "./dcheck.svg";

const FEMALE = "FEMALE";
const MALE = "MALE";
const ALL = "ANY";

const SEX_VALUES = [
  { value: FEMALE, name: "женщину" },
  { value: MALE, name: "мужчину" },
  { value: ALL, name: "друга любого пола" }
];

const AGE_VALUES = [
  { value: "18_21", name: "от 18 до 21" },
  { value: "21_25", name: "от 21 до 25" },
  { value: "25_30", name: "от 25 до 30" },
  { value: "30_35", name: "от 30 до 35" },
  { value: "35_40", name: "от 35 до 40" },
  { value: "40_45", name: "от 40 до 45" },
  { value: "45_", name: "старше 45" },
  { value: ALL, name: "любого возраста" }
];

const MARITAL_VALUES = [
  { value: "MARRIED", name: "в браке" },
  { value: "SINGLE", name: "не в браке" },
  { value: ALL, name: "любого семейного положения" }
];

const CITY_VALUES = [
  { value: ALL, name: "из любого города" },
  { value: "Moscow", name: "из Москвы" },
  { value: "St. Petersburg", name: "из Санкт-Петербурга" },
  { value: "Nizhny Novgorod", name: "из Нижнего Новгорода" },
  { value: "Yekaterinburg", name: "из Екатеринбурга" },
  { value: "Minsk", name: "из Минска" },
  { value: "Novosibirsk", name: "из Новосибирска" },
  { value: "Odessa", name: "из Одессы" },
  { value: "Kiev", name: "из Киева" },
  { value: "Simferopol", name: "из Симферополя" },
  { value: "Kazan", name: "из Казани" },
  { value: "Rostov-on-Don", name: "из Ростова-на-Дону" },
  { value: "Sasovo", name: "из Сасово" },
  { value: "Ivanteevka", name: "из Ивантеевки" },
  { value: "Istanbul", name: "из Стамбула" },
  { value: "Vladimir", name: "из Владимира" },
  { value: "Mytishchi", name: "из Мытищ" },
  { value: "Helsinki", name: "из Хельсинки" },
  { value: "Berlin", name: "из Берлина" },
  { value: "Palo Alto", name: "из Пало-Алто" },
  { value: "Lucerne", name: "из Люцерна" },
  { value: "Amsterdam", name: "из Амстердама" },
  { value: "Shanghai", name: "из Шанхая" },
  { value: "Tel Aviv", name: "из Тель-Авива" },
  { value: "Sochi", name: "из Сочи" }
];

const FINDER_VALUES = [
  { value: "1", name: "тех, кто ищет пару" },
  { value: ALL, name: "всех" }
];

const MALE_AVATAR_URL = "https://jing.yandex-team.ru/files/cberg/male-anon.jpg";

const FEMALE_AVATAR_URL =
  "https://jing.yandex-team.ru/files/cberg/female-anon.jpg";

let csrf;

const firstWords = x => {
  return x.replace(/^(.{25}[^\s]*).*/, "$1");
};

function backend(route, args) {
  const params = { ...args, csrf };
  const api = "https://cnd.crypta.yandex-team.ru/";
  const url = `${api}${route}`;

  return fetch(url, {
    body: JSON.stringify(params),
    credentials: "include",
    method: "post"
  });
}

class Chooser extends Component {
  render() {
    var radios = _.map(this.props.possibleValues, each => {
      return (
        <Item key={each.value} value={each.value}>
          {each.name}
        </Item>
      );
    });

    return (
      <span className={this.props.outerClass}>
        <Select
          theme="islands"
          mode="radio"
          size="m"
          value={this.props.current}
          onChange={this.props.onChange}
        >
          {radios}
        </Select>
      </span>
    );
  }
}

class AltImg extends Component {
  state = {
    loaded: true
  };

  componentDidMount() {
    var self = this;
    var img = new Image();
    img.src = this.props.src;
    img.onerror = () => {
      self.setState({ loaded: false });
    };
    img.onload = () => {
      self.setState({ loaded: true });
    };
  }

  render() {
    if (this.state.loaded) {
      return (
        <span>
          <img alt="" className={this.props.className} src={this.props.src} />
        </span>
      );
    } else {
      return <span className="unknown-image">кто-то</span>;
    }
  }
}

class Avatar extends Component {
  render() {
    const login = this.props.login;
    const type = this.props.type;
    const theClass = this.props.active
      ? "avatar-image-hovered"
      : "avatar-image";
    let url =
      "https://center.yandex-team.ru/api/v1/user/" + login + "/avatar/200.jpg";
    let overlay = (
      <div className="avatar-overlay-inner">
        <div
          className="avatar-chat-icon"
          onClick={() => this.props.handleStartChatClick()}
        >
          <FontAwesome className="staff" name="comment" />
        </div>
        <div
          className="avatar-staff-icon"
          onClick={() => {
            window.open("https://staff.yandex-team.ru/" + login, "_blank");
          }}
        >
          <FontAwesome className="staff" name="id-card" />
        </div>
      </div>
    );

    const staff = this.props.active ? (
      <div
        className={classNames("avatar-overlay", {
          "avatar-overlay-ad": type === "ad"
        })}
      >
        {overlay}
      </div>
    ) : (
      ""
    );

    return (
      <div className={classNames("avatar", { "avatar-ad": type === "ad" })}>
        {type === "ad" ? (
          <div className="avatar-ad-icon">
            <FontAwesome name="comments" />
          </div>
        ) : null}
        <AltImg className={theClass} src={url} />
        {staff}
      </div>
    );
  }
}

class Candidate extends Component {
  state = {
    hovered: false
  };

  constructor() {
    super();
    this.onHover = this.onHover.bind(this);
    this.onLeave = this.onLeave.bind(this);
  }

  onHover() {
    this.setState({ hovered: true });
  }

  onLeave() {
    this.setState({ hovered: false });
  }

  handleStartChatClick() {
    this.props.handleStartChatClick(this.props.login);
  }

  render() {
    const sexToIcon = {
      male: <FontAwesome name="mars" />,
      female: <FontAwesome name="venus" />
    };
    const login = this.props.login;
    const name = this.props.name;
    const sex = this.props.sex;
    const age = this.props.age;
    const position = this.props.position;
    const type = this.props.type;
    const theClass = this.state.hovered ? "candidate-active" : "candidate";

    return (
      <div
        href={"https://staff.yandex-team.ru/" + login}
        className={classNames(theClass, { "candidate-ad": type === "ad" })}
        onMouseEnter={this.onHover}
        onMouseLeave={this.onLeave}
      >
        <Avatar
          active={this.state.hovered}
          key={login}
          login={login}
          type={type}
          handleStartChatClick={() => this.handleStartChatClick()}
        />
        <br />
        <div
          className={classNames("candidate-info", {
            "candidate-info-ad": type === "ad"
          })}
        >
          <span className="candidate-name">{name}</span>{" "}
          <span className="candidate-sex-age">
            {sexToIcon[sex]} {age}
          </span>
          <div className="candidate-position">
            {type === "ad"
              ? firstWords(position)
              : firstWords(position.toLowerCase())}
          </div>
        </div>
      </div>
    );
  }
}

class Inbox extends Component {
  _handleClick() {
    this.props.handleClick();
  }

  render() {
    return (
      <div
        className={classNames("inbox", { "inbox-active": this.props.active })}
        onClick={() => this._handleClick()}
      >
        <span className="inbox-title">Мои чаты</span>

        <span className="inbox-icon">
          <FontAwesome name="comments" />
        </span>
      </div>
    );
  }
}

class SearchBox extends Component {
  componentWillReceiveProps(nextProps, nextState) {
    if (nextProps.isStartChatFocused) {
      const startChatInputMessage = this.startChatInputMessage;
      const searchBlock = this.searchBlock;

      searchBlock.focus();
      startChatInputMessage.focus();
    }
  }

  _handleInputLogin(e) {
    const value = e.target.value;

    this.props.handleInputLogin(value);
  }

  _handleInputMessage(e) {
    const value = e.target.value;

    this.props.handleInputMessage(value);
  }

  _handleBlurMessage() {
    this.props.handleBlurMessage();
  }

  _handleButtonClick(e) {
    e && e.preventDefault();
    this._handleSave();
  }

  _handleSubmit(e) {
    if (e.key === "Enter") {
      this._handleSave();
    }
  }

  _handleSave() {
    this.props.handleSubmit();
  }

  render() {
    return (
      <div className="search-box" ref={element => (this.searchBlock = element)}>
        <div className="search-box-inner">
          <h2 className="search-box-title">
            Никто не подошел?
          </h2>
          <p>
            Укажи произвольный логин и начни анонимный чат. Собеседник узнает
            только твой пол и возраст
          </p>
          <div className="search-box-form">
            <form className="search-box-form-inner">
              <input
                type="text"
                placeholder="Введите логин"
                className="search-box-form-input search-box-form-input-login"
                value={this.props.login}
                onChange={e => this._handleInputLogin(e)}
                onKeyPress={e => this._handleSubmit(e)}
              />
              <input
                ref={element => (this.startChatInputMessage = element)}
                type="text"
                className="search-box-form-input search-box-form-input-message"
                value={this.props.message}
                placeholder="Привет, ты мне нравишься!"
                onChange={e => this._handleInputMessage(e)}
                onKeyPress={e => this._handleSubmit(e)}
                onBlur={() => this._handleBlurMessage()}
              />
              <a
                href=""
                className="search-box-form-button"
                onClick={e => this._handleButtonClick(e)}
              >
                Начать чат
              </a>
            </form>
          </div>
        </div>
      </div>
    );
  }
}

class Sidebar extends Component {
  render() {
    return (
      <div className="sidebar">
        <div className="sidebar-content">
          {this.props.isChatOpened ? (
            <Chat
              handleBack={() => this.props.handleChatBack()}
              dialog={this.props.dialog}
              login={this.props.login}
            />
          ) : (
            <Chats
              handleChatClick={dialog => this.props.handleChatClick(dialog)}
              login={this.props.login}
              isChatsFiltered={this.props.isChatsFiltered}
              handleChatsFilterChange={value =>
                this.props.handleChatsFilterChange(value)
              }
            />
          )}
        </div>
        <div
          onClick={() => this.props.handleOverlayClick()}
          className="sidebar-overlay"
        />
      </div>
    );
  }
}

class Heart extends Component {
  render() {
    return <div className="heart-loader" />;
  }
}

class Chats extends Component {
  state = {
    dialogs: [],
    hasError: false,
    isLoading: false
  };

  componentDidMount() {
    const login = this.props.login;

    this._fetchDialogs(login);
  }

  _fetchDialogs(login) {
    const isLoading = true;

    this.setState({ isLoading });

    backend("_cnd_dialog_list", {
      login
    })
      .then(response => {
        response.json().then(json => {
          this.setState({
            isLoading: false,
            dialogs: json["dialogs"],
            hasError: false
          });
        });
      })
      .catch(error => {
        const hasError = true;
        const isLoading = false;

        console.log(error);
        this.setState({ hasError, isLoading });

        setTimeout(
          (self, login) => self._fetchDialogs(login),
          3000,
          this,
          login
        );
      });
  }

  _handleChatClick(dialog) {
    this.props.handleChatClick(dialog);
  }

  render() {
    const { dialogs = [], isLoading = false, hasError = false } = this.state;
    const dialogsList = this.props.isChatsFiltered
      ? dialogs.filter(item => item.isOnline)
      : dialogs;
    const dialogsBlock = dialogsList.map((dialog, index) => {
      const sex = dialog.sex === "male" ? "М" : "Ж";
      const id = String(dialog.chatid).slice(-2);
      let url = `url(${`https://center.yandex-team.ru/api/v1/user/${
        dialog.login
      }/avatar/200.jpg`})`;
      let name = dialog.name;

      if (dialog.login === "anonym") {
        url =
          dialog.sex === "male"
            ? `url(${MALE_AVATAR_URL})`
            : `url(${FEMALE_AVATAR_URL})`;
        name =
          dialog.sex === "male"
            ? MALE_ANONYMOUS_NAMES[id]
            : FEMALE_ANONYMOUS_NAMES[id];
      }

      return (
        <div
          key={index}
          onClick={this._handleChatClick.bind(this, dialog)}
          className="contact zigzag"
        >
          <div
            data-content={dialog.unreaded_messages}
            style={{ backgroundImage: url }}
            className={classNames("contact-avatar", {
              "contact-avatar-label": dialog.unreaded_messages
            })}
          />
          <div className="contact-name">{name}</div>
          <div
            data-content={dialog.isOnline}
            className={classNames("contact-info", {
              "contact-info-label": dialog.isOnline
            })}
          >
            {dialog.age ? `${sex}, ${dialog.age}` : sex}
          </div>
        </div>
      );
    });
    const isChatsFiltered = this.props.isChatsFiltered;

    if (isLoading) {
      return <Heart />;
    }

    if (hasError) {
      return (
        <div className="chats chats-error">
          <FontAwesome name="meh-o" />
          <span className="chats-empty-title">Что-то пошло не так</span>
        </div>
      );
    }

    if (dialogs.length === 0) {
      return (
        <div className="chats chats-empty">
          <FontAwesome name="comments" />
          <span className="chats-empty-title">У вас пока нет чатов</span>
        </div>
      );
    }

    return (
      <div className="chats">
        <div className="chats-header">
          <h1 className="chats-title">Мои чаты</h1>
          <div className="chats-filter">
            <span className="chats-hint">показывать</span>
            <div className="chats-radio">
              <div key={0} className="item">
                <input
                  type="radio"
                  name="filter"
                  id="filter_0"
                  value={false}
                  onChange={e => this.props.handleChatsFilterChange(false)}
                  defaultChecked={isChatsFiltered === false}
                />
                <label htmlFor="filter_0">всех</label>
              </div>

              <div key={1} className="item">
                <input
                  type="radio"
                  name="filter"
                  id="filter_1"
                  value={true}
                  onChange={e => this.props.handleChatsFilterChange(true)}
                  defaultChecked={isChatsFiltered === true}
                />
                <label htmlFor="filter_1">онлайн</label>
              </div>
            </div>
          </div>
        </div>
        <div className="chats-content">{dialogsBlock}</div>
      </div>
    );
  }
}

class Chat extends Component {
  state = {
    isLoading: false,
    isNewMessageLocked: false,
    isOnline: false,
    isDeleted: false,
    messages: [],
    text: ""
  };

  componentDidMount() {
    const { login = "" } = this.props;
    const { chatid = 0 } = this.props.dialog;

    this._updateScroll();
    this._fetchMessages(login, chatid);
    this.intervalID = setInterval(
      (login, chatid) => this._fetchMessages(login, chatid),
      2500,
      login,
      chatid
    );
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevState.messages.length !== this.state.messages.length) {
      this._updateScroll();
    }
  }

  componentWillUnmount() {
    clearInterval(this.intervalID);
  }

  _fetchMessages(login, chatid) {
    if (!document.hidden) {
      backend("_cnd_messages", {
        login,
        chatid
      })
        .then(response => {
          response.json().then(json => {
            this.setState({
              isDeleted: json["isDeleted"],
              isOnline: json["isOnline"],
              messages: json["messages"]
            });
          });
        })
        .catch(error => {
          console.log(error);
        });
    }
  }

  _fetchBanChat(login, chatid) {
    backend("_cnd_ban_chat", {
      login,
      chatid
    })
      .then(response => {
        response.json().then(() => {
          this._handleBack();
        });
      })
      .catch(error => {
        console.log(error);
      });
  }

  _fetchMessageAdd() {
    let { isNewMessageLocked = false, text = "" } = this.state;

    if (!isNewMessageLocked) {
      const { login = "", dialog = {} } = this.props;
      const { chatid = 0 } = dialog;

      this.setState({ isNewMessageLocked: true });

      backend("_cnd_new_message", {
        login,
        chatid,
        text
      })
        .then(response => {
          response.json().then(json => {
            this.setState({ text: "", isNewMessageLocked: false });
          });
        })
        .catch(error => {
          console.log(error);
        });
    }
  }

  _handleInput(e) {
    const text = e.target.value;

    this.setState({ text });
  }

  _handleSubmit(e) {
    if (e.key === "Enter") {
      this._fetchMessageAdd();
    }
  }

  _handleBack(e) {
    e && e.preventDefault();

    this.props.handleBack();
  }

  _handleButtonClick(e) {
    e && e.preventDefault();

    this._fetchMessageAdd();
  }

  _updateScroll() {
    const messagesBlock = this._messagesBlock;

    messagesBlock.scrollTop = messagesBlock.scrollHeight;
  }

  _goStaff(e) {
    e && e.preventDefault();
    const { dialog = {} } = this.props;

    if (dialog.login !== "anonym") {
      window.open("https://staff.yandex-team.ru/" + dialog.login, "_blank");
    }
  }

  _handleBan(e) {
    e && e.preventDefault();
    const { isDeleted = false } = this.state;

    if (!isDeleted) {
      const isConfimed = confirm(
        "Вы действительно  хотите заблокировать пользователя? Чат будет удален у вас и собеседника. Этот пользователь больше не сможет написать вам."
      );
      const { login = "" } = this.props;
      const { chatid = 0 } = this.props.dialog;

      if (isConfimed) {
        this._fetchBanChat(login, chatid);
      }
    }
  }

  render() {
    const {
      isLoading = false,
      isOnline = false,
      isDeleted = false
    } = this.state;
    let { messages = [] } = this.state;

    if (isDeleted) {
      messages = [].concat(messages);
      messages.push({
        text: "Собеседник завершил беседу",
        service: true
      });
    }

    const { dialog = {} } = this.props;
    const comments = messages.map((message, index) => {
      const { text, ts, mine: self, isRead, service = false } = message;
      const date = new Date(ts);
      const formattedDate = date.toLocaleString("ru", {
        hour: "numeric",
        minute: "numeric"
      });

      return (
        <Comment
          key={index}
          date={formattedDate}
          isRead={isRead}
          self={self}
          text={text}
          service={service}
        />
      );
    });

    const sex = dialog.sex === "male" ? "М" : "Ж";
    const id = String(dialog.chatid).slice(-2);
    let url = `url(${`https://center.yandex-team.ru/api/v1/user/${
      dialog.login
    }/avatar/200.jpg`})`;
    let name = dialog.name;

    if (dialog.login === "anonym") {
      url =
        dialog.sex === "male"
          ? `url(${MALE_AVATAR_URL})`
          : `url(${FEMALE_AVATAR_URL})`;
      name =
        dialog.sex === "male"
          ? MALE_ANONYMOUS_NAMES[id]
          : FEMALE_ANONYMOUS_NAMES[id];
    }

    if (isLoading) {
      return <Heart />;
    }

    return (
      <section className="chat">
        <nav className="chat-nav">
          <div
            className={classNames("chat-nav-avatar", {
              "chat-nav-avatar-clickable": dialog.login !== "anonym"
            })}
            onClick={() => this._goStaff()}
            style={{
              backgroundImage: url
            }}
          />
          <div className="chat-nav-info">
            <div
              className={classNames("chat-nav-name", {
                "chat-nav-name-clickable": dialog.login !== "anonym"
              })}
              onClick={() => this._goStaff()}
            >
              {name || "Аркадий"}
            </div>
            <div
              className={classNames("chat-nav-details", {
                "chat-nav-details-label": isOnline
              })}
            >
              {dialog.age ? `${sex}, ${dialog.age}` : sex}
            </div>
          </div>
          <ul className="chat-nav-options">
            <li onClick={e => this._handleBack(e)}>
              <a href="#">К чатам</a>
            </li>
            <li className="drop">
              Еще
              <ul>
                <li
                  className={classNames({ disabled: isDeleted })}
                  onClick={e => this._handleBan(e)}
                >
                  <a href="#">Заблокировать</a>
                </li>
                <li
                  className={classNames({
                    disabled: dialog.login === "anonym"
                  })}
                >
                  <a href="#" onClick={e => this._goStaff(e)}>
                    Стафф
                  </a>
                </li>
              </ul>
            </li>
          </ul>
        </nav>

        <div
          className="chat-messages"
          ref={element => (this._messagesBlock = element)}
        >
          <div className="chat-messages-inner">{comments}</div>
        </div>
        <div className="chat-form">
          <div className="chat-form-inner">
            <input
              type="text"
              placeholder="Введите текст"
              className="chat-form-input"
              autoFocus={true}
              disabled={isDeleted}
              value={this.state.text}
              onChange={e => this._handleInput(e)}
              onKeyPress={e => this._handleSubmit(e)}
            />
            <a
              href=""
              className={classNames("chat-form-button", {
                "chat-form-button-disabled": isDeleted
              })}
              onClick={e => this._handleButtonClick(e)}
            >
              Отправить
            </a>
          </div>
        </div>
      </section>
    );
  }
}

class Comment extends Component {
  render() {
    const checkBlock = this.props.isRead ? (
      <img src={dcheck} alt="" />
    ) : (
      <img src={check} alt="" />
    );

    return (
      <div className="comment">
        <div
          className={classNames("comment-inner", {
            "comment-self": this.props.self,
            "comment-buddy": !this.props.self,
            "comment-service": this.props.service
          })}
        >
          {this.props.service ? null : (
            <div className="comment-date">
              <span>{this.props.date}</span>
              {checkBlock}
            </div>
          )}
          <div className="comment-message">{this.props.text}</div>
        </div>
      </div>
    );
  }
}

class Finder extends Component {
  state = {
    amilover: false,
    all_lovers: 0,
    male_lovers: 0,
    female_lovers: 0
  };

  render() {
    return (
      <div className="finder">
        <div className="finder-switcher">
          <div className="finder-title">Я ищу пару</div>
          <div className="toggler">
            <input
              type="checkbox"
              onChange={e => this.props.handleFinderChange(e.target.checked)}
              checked={this.props.isFinder}
            />
            <label />
          </div>
        </div>
        <div className="finder-statistics">
          <span>
            Всего ищут{" "}
            <span className="finder-counter">
              {this.props.totalCounter || 0}
            </span>
            , из них{" "}
            <span className="finder-counter">
              {this.props.maleCounter || 0}
            </span>{" "}
            <span className="finder-male">
              <FontAwesome name="mars" />
            </span>{" "}
            и{" "}
            <span className="finder-counter">
              {this.props.femaleCounter || 0}
            </span>{" "}
            <span className="finder-female">
              <FontAwesome name="venus" />
            </span>
          </span>
        </div>
      </div>
    );
  }
}

class Notifications extends Component {
  state = {
    isNotificationEnabled: true
  };

  render() {
    return (
      <div className="notifications">
        <div className="notifications-switcher">
          <div className="notifications-title">Уведомления</div>
          <div className="toggler">
            <input
              type="checkbox"
              onChange={e =>
                this.props.handleNotificationsChange(e.target.checked)
              }
              checked={this.props.isNotificationEnabled}
            />
            <label />
          </div>
        </div>
        <div className="notifications-statistics">
          <span>Хочу получать письма о непрочитанных сообщениях</span>
        </div>
      </div>
    );
  }
}

class App extends Component {
  state = {
    activeDialog: {},
    age: [ALL],
    candidates: [],
    city: [ALL],
    failed: false,
    failedWhy: "Мы уже знаем об этой проблеме",
    femaleCounter: 0,
    finder: [ALL],
    isChatOpened: false,
    isChatsFiltered: false,
    isFinder: false,
    isFinderChangeLocked: false,
    isNotificationEnabled: true,
    isNotificationEnabledLocked: false,
    isSidebarOpened: false,
    isStartChatFocused: false,
    loaded: false,
    login: undefined,
    maleCounter: 0,
    marital: [ALL],
    score: undefined,
    sex: [ALL],
    startChatLogin: "",
    startChatMessage: "",
    totalCounter: 0,
    unreaded_dialogs: false
  };

  constructor() {
    super();

    this.onSexChange = this.onSexChange.bind(this);
    this.onAgeChange = this.onAgeChange.bind(this);
    this.onMaritalChange = this.onMaritalChange.bind(this);
    this.onCityChange = this.onCityChange.bind(this);
    this.onLoverChange = this.onLoverChange.bind(this);
    this.fetchLogin = this.fetchLogin.bind(this);
    this.fetchCandidates = this.fetchCandidates.bind(this);
    this.fetchRank = this.fetchRank.bind(this);
  }

  componentDidMount() {
    this.fetchLogin(() => {
      this.fetchCsrfToken(() => {
        this.fetchRank();
        this.fetchCandidates();
        this.fetchGeneralData(this);
        this._checkUrl();
      });
    });

    setInterval(self => this.fetchGeneralData(self), 10000, this);
  }

  fetchCsrfToken(callback) {
    backend("_cnd_get_csrf", {
      login: this.state.login
    })
      .then(response => response.json())
      .then(json => {
        csrf = json["csrf"];
        callback.call(this);
      })
      .catch(error => {
        console.log(error);
        alert(
          "Сервера не отвечают. Возможно, мы перенастраиваем наши сервера - возвращайтесь минут через 10, все должно работать ;)"
        );
      });
  }

  fetchGeneralData(self) {
    if (!document.hidden) {
      backend("_cnd_get_status", {
        login: this.state.login
      })
        .then(response => response.json())
        .then(json => {
          const isFinderChangeLocked = this.state.isFinderChangeLocked;
          const isNotificationEnabledLocked = this.state
            .isNotificationEnabledLocked;

          if (isFinderChangeLocked || isNotificationEnabledLocked) {
            this.setState({
              unreaded_dialogs: Number(json["unreaded_dialogs"]),
              totalCounter: Number(json["all"]),
              maleCounter: Number(json["male"]),
              femaleCounter: Number(json["female"])
            });
          } else {
            this.setState({
              unreaded_dialogs: Number(json["unreaded_dialogs"]),
              isFinder: Boolean(Number(json["status"])),
              isNotificationEnabled: Boolean(
                Number(json["is_notification_enabled"])
              ),
              totalCounter: Number(json["all"]),
              maleCounter: Number(json["male"]),
              femaleCounter: Number(json["female"])
            });
          }

          let unreaded_dialogs = Number(json["unreaded_dialogs"]);

          if (unreaded_dialogs) {
            document.title = `(${json["unreaded_dialogs"]}) Dating`;
          } else {
            document.title = `Dating`;
          }

          return;
        })
        .catch();
    }
  }

  _checkUrl() {
    if (/chats=1/.test(window.location.search)) {
      const isSidebarOpened = true;

      this.setState({ isSidebarOpened });
    }
  }

  _updateSidebarView() {
    const isSidebarOpened = !this.state.isSidebarOpened;
    const isChatOpened = false;
    const unreaded_dialogs = false;

    this.setState({ isSidebarOpened, unreaded_dialogs, isChatOpened });
  }

  _updateChatView(dialog) {
    const isChatOpened = true;
    const activeDialog = dialog;

    this.setState({ isChatOpened, activeDialog });
  }

  _updateSidebarState() {
    const isChatOpened = false;

    this.setState({ isChatOpened });
  }

  _handleFinderChange(isFinder) {
    const isFinderChangeLocked = true;

    this.setState({ isFinder, isFinderChangeLocked });

    backend("_cnd_change_status", {
      login: this.state.login,
      lover: String(Number(isFinder))
    })
      .then(response => {
        this.setState({ isFinderChangeLocked: false });
        this.fetchGeneralData(this);
      })
      .catch(error => {
        console.log(error);
      });
  }

  _handleNotificationsChange(isNotificationEnabled) {
    const isNotificationEnabledLocked = true;

    this.setState({ isNotificationEnabled, isNotificationEnabledLocked });

    backend("_cnd_change_status", {
      login: this.state.login,
      is_notification_enabled: String(Number(isNotificationEnabled))
    })
      .then(response => {
        this.setState({ isNotificationEnabledLocked: false });
        this.fetchGeneralData(this);
      })
      .catch(error => {
        console.log(error);
      });
  }

  _fetchStartChat(other, text) {
    const { login } = this.state;
    const isSidebarOpened = true;

    backend("_cnd_new_dialog", {
      login,
      other,
      text
    })
      .then(response => {
        response.json().then(json => {
          if (json["Error"]) {
            alert(json["Error"]);
          } else {
            this.setState({ isSidebarOpened });
          }
        });
      })
      .catch(error => {
        console.log(error);
        alert("Но что-то пошло совсем не так");
      });
  }

  handleStartChatClick(login) {
    const startChatLogin = login;
    const startChatMessage = "Привет, ты мне нравишься!";
    const isStartChatFocused = true;

    this.setState({ startChatLogin, isStartChatFocused, startChatMessage });
  }

  handleStartChatSubmit() {
    const { startChatLogin = "" } = this.state;
    let { startChatMessage = "" } = this.state;

    if (!startChatMessage) {
      startChatMessage = "Привет, ты мне нравишься!";
    }

    this._fetchStartChat(startChatLogin, startChatMessage);
  }

  handleStartChatInputLogin(value) {
    const startChatLogin = value;

    this.setState({ startChatLogin });
  }

  handleStartChatInputMessage(value) {
    const startChatMessage = value;

    this.setState({ startChatMessage });
  }

  handleStartChatBlurMessage() {
    const isStartChatFocused = false;

    this.setState({ isStartChatFocused });
  }

  fetchRank() {
    backend("_cnd_data_rank", {
      login: this.state.login,
      other: this.state.login
    })
      .then(response => response.json())
      .then(json => this.setState({ score: json["rank"] }))
      .catch(error => this.setState({ score: undefined }));
  }

  fetchCandidates() {
    backend("_cnd_data_friends", {
      login: this.state.login,
      sex: this.state.sex[0],
      age: this.state.age[0],
      martial: this.state.marital[0],
      city: this.state.city[0],
      lover: this.state.finder[0]
    })
      .then(response => {
        if (response.status !== 200) {
          this.setState({ failed: true, failedWhy: response.status });
          return;
        }
        response.json().then(json => {
          if (!(json["friends"] === undefined)) {
            let candidates = json["friends"];

            this.setState({ candidates });
          }
          this.setState({ loaded: true });
        });
      })
      .catch(error => {
        console.log(error);

        this.setState({
          failed: true,
          failedWhy: "Но что-то пошло совсем не так"
        });
      });
  }

  fetchLogin(callback) {
    this.setState(
      { login: cookie.load("yandex_login") || "robot-crypta" },
      callback
    );
  }

  onSexChange(value) {
    this.setState({ sex: value }, () => this.fetchCandidates());
  }

  onAgeChange(value) {
    this.setState({ age: value }, () => this.fetchCandidates());
  }

  onMaritalChange(value) {
    this.setState({ marital: value }, () => this.fetchCandidates());
  }

  onCityChange(value) {
    this.setState({ city: value }, () => this.fetchCandidates());
  }

  onLoverChange(value) {
    this.setState({ finder: value }, () => this.fetchCandidates());
  }

  onFinderChange(value) {
    this.setState({ isFinder: value }, () => this.fetchCandidates());
  }

  handleChatsFilterChange(value) {
    console.log("handleChatsFilterChange", value);
    this.setState({ isChatsFiltered: value });
  }

  render() {
    const candidates = _.map(this.state.candidates, each => (
      <Candidate
        key={each.login}
        login={each.login}
        name={each.name}
        from={this.state.login}
        sex={each.sex}
        age={each.age === "unknown" ? "" : each.age}
        position={each.position}
        type={each.type}
        handleStartChatClick={login => this.handleStartChatClick(login)}
      />
    ));
    var candidatesScreen = (
      <div key="candidates" className="candidates">
        {" "}
        {candidates}{" "}
      </div>
    );

    if (!this.state.loaded && !this.state.failed) {
      candidatesScreen = (
        <div key="candidates" className="candidates">
          <div className="candidates-spinner">
            <Spinner theme="islands" size="xl" />
          </div>
        </div>
      );
    } else {
      if (this.state.failed) {
        candidatesScreen = (
          <div key="candidates" className="candidates">
            <span className="sad">:(</span>
            {this.state.failedWhy ? (
              <span className="sad-why">{this.state.failedWhy}</span>
            ) : (
              ""
            )}
          </div>
        );
      } else if (
        this.state.candidates.length === 0 ||
        this.state.candidates.length === 1
      ) {
        candidatesScreen = (
          <div key="candidates" className="candidates">
            <span className="sad-why">Никого не нашлось</span>
          </div>
        );
      }
    }
    var mayFound = this.state.failed ? (
      <span>могли бы</span>
    ) : (
      <span>можем</span>
    );

    return (
      <div key="app" className="App" ref={el => (this.AppBlock = el)}>
        <header className="header">
          <div className="you">
            <div className="you-info">
              <div>Привет, </div>
              <Avatar login={this.state.login} />
            </div>
            <div className="you-actions">
              <Finder
                handleFinderChange={isFinder =>
                  this._handleFinderChange(isFinder)
                }
                isFinder={this.state.isFinder}
                totalCounter={this.state.totalCounter}
                maleCounter={this.state.maleCounter}
                femaleCounter={this.state.femaleCounter}
              />
              <Notifications
                handleNotificationsChange={isNotificationEnabled =>
                  this._handleNotificationsChange(isNotificationEnabled)
                }
                isNotificationEnabled={this.state.isNotificationEnabled}
              />
              <Inbox
                handleClick={() => this._updateSidebarView()}
                active={this.state.unreaded_dialogs}
              />
            </div>
          </div>

          <nav className="filters">
            <div key="parameters" className="parameters">
              <div className="but">мы {mayFound} найти</div>
              <Chooser
                key="sex"
                possibleValues={SEX_VALUES}
                outerClass="sex"
                current={this.state.sex}
                onChange={this.onSexChange}
              />
              &nbsp;
              <Chooser
                key="age"
                possibleValues={AGE_VALUES}
                outerClass="age"
                current={this.state.age}
                onChange={this.onAgeChange}
              />
              &nbsp;
              <Chooser
                key="marital"
                possibleValues={MARITAL_VALUES}
                outerClass="marital"
                current={this.state.marital}
                onChange={this.onMaritalChange}
              />
              &nbsp;
              <Chooser
                key="city"
                possibleValues={CITY_VALUES}
                outerClass="city"
                current={this.state.city}
                onChange={this.onCityChange}
              />
            </div>
            <br />
            <div key="parameters-additional" className="parameters">
              <div className="but">показывать </div>
              <Chooser
                key="finder"
                possibleValues={FINDER_VALUES}
                outerClass="finder-filter"
                current={this.state.finder}
                onChange={this.onLoverChange}
              />
            </div>
          </nav>
        </header>

        <section className="candidates-content">
          <h1 className="candidates-content-title">
            Люди, которые похожи на тебя по поведению в интернете
          </h1>
          {candidatesScreen}
        </section>

        {this.state.isSidebarOpened ? (
          <Sidebar
            handleChatClick={dialog => this._updateChatView(dialog)}
            handleChatBack={() => this._updateSidebarState()}
            handleOverlayClick={() => this._updateSidebarView()}
            handleChatsFilterChange={value =>
              this.handleChatsFilterChange(value)
            }
            isChatOpened={this.state.isChatOpened}
            login={this.state.login}
            dialog={this.state.activeDialog}
            isChatsFiltered={this.state.isChatsFiltered}
          />
        ) : null}

        <section className="search-box-content">
          <SearchBox
            login={this.state.startChatLogin}
            message={this.state.startChatMessage}
            isStartChatFocused={this.state.isStartChatFocused}
            handleSubmit={() => this.handleStartChatSubmit()}
            handleInputLogin={value => this.handleStartChatInputLogin(value)}
            handleInputMessage={value =>
              this.handleStartChatInputMessage(value)
            }
            handleBlurMessage={() => this.handleStartChatBlurMessage()}
          />
        </section>
      </div>
    );
  }
}

export default App;
