const fs = require("fs");
const opn = require("opn");
const path = require("path");
const webpack = require("webpack");
const WebpackDevServer = require("webpack-dev-server");
const BundleAnalyzerPlugin = require("webpack-bundle-analyzer").BundleAnalyzerPlugin;

const CWD = process.cwd();
const CONFIG = {
    host: "localhost",
    port: require(path.resolve(CWD, ".port")),
};

const webpackConfig = require(path.join(CWD, "webpack.config"));
const devServerHost = require(path.join(CWD, ".devhost"));
let webpackDevServerEntry = "webpack-dev-server/client" + "?" + devServerHost;
let webpackHotDevServerEntry = "webpack/hot/dev-server";
webpackConfig.entry = [webpackDevServerEntry, webpackHotDevServerEntry].concat(webpackConfig.entry);

const compiler = webpack(webpackConfig);

function start() {
    new WebpackDevServer(compiler, {
        compress: true,
        disableHostCheck: true,
        hot: true,
        quiet: false,
        overlay: {
            warnings: false,
            errors: true,
        },
        publicPath: webpackConfig.output.publicPath,
        https: false,
        historyApiFallback: true,
    }).listen(CONFIG.port, CONFIG.host, (error) => {
        if (error) {
            return console.error(error);
        } else {
            opn(devServerHost);
        }
    });
}

module.exports = start();
