from crypta.lib.python.spine import arcadia_ci
from crypta.lib.python.spine.juggler import juggler_check_generator


def get_registry():
    juggler = juggler_check_generator.CryptaYtCheckGenerator(
        host="crypta-web-lab",
        tags=["crypta-web-lab"],
    )

    release_registry = arcadia_ci.CryptaReleaseGenerator(juggler).standard_release(
        title="Lab frontend",
        abs_paths=["crypta/web/lab/**"],
    )

    add_web_lab(release_registry)

    return juggler


def add_web_lab(release_registry):
    release_registry.add_docker_image("crypta/web/lab/docker/crypta-web-lab.json")
