import React, { useEffect } from "react";
import { Redirect, Route, Switch } from "react-router-dom";

import Segments from "segments";
import Samples from "samples";
import Audiences from "audiences/Audiences";
import DirectLoader from "DirectLoader";
import TrainingSamples from "./training_samples";
import Layout from "Layout";
import Notifications from "./utils/notifications/Notifications";
import { provideUserParams } from "./metrika";

const App = (props) => {
    useEffect(() => {
        setTimeout(provideUserParams, 5000);
    }, []);

    return (
        <Layout>
            <Switch>
                <Route path="/segments" component={Segments} />
                <Route path="/samples">
                    <Samples />
                </Route>
                <Route path="/training_samples" component={TrainingSamples} />
                <Route path="/audiences" component={Audiences} />
                <Route path="/direct_loader" component={DirectLoader} />
                <Route path="/predictive_analytics">
                    <Samples dated />
                </Route>
                <Redirect exact from="/" to="/segments" />
            </Switch>

            <Notifications />
        </Layout>
    );
};

export default App;
