import React from "react";
import { NavLink as RouterLink, withRouter } from "react-router-dom";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import Link from "@lib/components/link";
import { getAccessState, getApiBetaState } from "selectors";

import regularLogoPic from "images/cat.svg";
import nyLogoPic from "images/nycat.svg";
import helpPic from "images/help.svg";
import coursePic from "images/course.png";
import telegramPic from "images/telegram-monochrome.svg";

import "./AppHeader.scss";

const LABORATORY_HELP_URL = "https://wiki.yandex-team.ru/crypta/crypta-up/lab/";
const CRYPTA_TELEGRAM_URL = "https://t.me/joinchat/GY4mgwUKuOKjNF4b";
const LABORATORY_COURCE_URL = "https://moe.yandex-team.ru/courses/library/course/1525";

const logoPic = () => {
    let date = new Date();
    if (date.getMonth() === 11) {
        if (date.getDate() >= 25) {
            return nyLogoPic;
        }
    }
    if (date.getMonth() === 0) {
        if (date.getDate() <= 10) {
            return nyLogoPic;
        }
    }
    return regularLogoPic;
};

const AppHeader = connect((state) => ({
    beta: getApiBetaState(state),
    access: getAccessState(state),
}))((props) => {
    const { beta, access } = props;

    const { t } = useTranslation("common");
    return (
        <div className="AppHeader">
            <div className="AppHeader__left-pane">
                <div className="AppHeader__arrow">
                    <div className="AppHeader__arrow-label">
                        <img alt="" className="AppHeader__logo" src={logoPic()} />
                        {t("menu.logo")}
                        {beta && <span className="AppHeader__beta">&beta;</span>}
                    </div>
                </div>
                <div className="AppHeader__menu">
                    {access && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/segments">
                                {t("menu.segments")}
                            </RouterLink>
                        </div>
                    )}
                    {access && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/samples">
                                {t("menu.samples")}
                            </RouterLink>
                        </div>
                    )}
                    {access && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/audiences">
                                {t("menu.audiences")}
                            </RouterLink>
                        </div>
                    )}
                    {access && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/training_samples">
                                {t("menu.trainingSamples")}
                            </RouterLink>
                        </div>
                    )}
                    {access && access.Geodirect && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/direct_loader">
                                {t("menu.directLoader")}
                            </RouterLink>
                        </div>
                    )}
                    {access && (
                        <div className="AppHeader__menu-item">
                            <a
                                className="AppHeader__menu-item-external-link"
                                target="_blank"
                                href="https://search.crypta.yandex-team.ru/?query=repin"
                            >
                                {t("menu.repin")}
                            </a>
                        </div>
                    )}
                    {access && (
                        <div className="AppHeader__menu-item">
                            <RouterLink className="AppHeader__menu-item-link" to="/predictive_analytics">
                                {t("menu.predictiveAnalytics")}
                            </RouterLink>
                        </div>
                    )}
                </div>
            </div>
            <div className="AppHeader__right-pane">
                <div className="AppHeader__help">
                    <Link href={CRYPTA_TELEGRAM_URL} title={t("menu.telegram")} target="_blank">
                        <img alt={t("menu.telegram")} className="AppHeader__telegram_pic" src={telegramPic} />
                    </Link>

                    <Link href={LABORATORY_COURCE_URL} title={t("menu.course")} target="_blank">
                        <img alt={t("menu.course")} className="AppHeader__course_pic" src={coursePic} />
                    </Link>

                    <Link href={LABORATORY_HELP_URL} title={t("menu.userGuide")} target="_blank">
                        <img alt="" className="AppHeader__help_pic" src={helpPic} />
                    </Link>
                </div>
            </div>
        </div>
    );
});

export default withRouter(AppHeader);
