import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";
import { ListGroup, ListGroupItem } from "react-bootstrap";
import moment from "moment";

import "./index.scss";
import "./Templates.scss";

import { copyTemplate } from "../actions";

class Templates extends React.Component {
    renderTemplate(template) {
        const { onClick } = this.props;
        const formattedDate = moment(template.creationTime).format("YYYY-MM-DD hh:mm:ss");
        return (
            <ListGroupItem active={false} key={template.id} onClick={() => onClick(template.id)}>
                <div>
                    <div className="FloatingLeft">{template.name}</div>
                    <div className="FloatingRight">{formattedDate}</div>
                </div>
            </ListGroupItem>
        );
    }

    render() {
        const { templates } = this.props;
        const renderedTemplates = templates.map((template) => this.renderTemplate(template));
        return (
            <div>
                <div>Шаблоны ({templates.length})</div>
                <div className="Templates">
                    <div className="ScrollingBlock">
                        <ListGroup>{renderedTemplates}</ListGroup>
                    </div>
                </div>
            </div>
        );
    }
}

// Leave this method for unification protocol of creating redux components
function mapStateToProps(state, ownProps) {
    return {};
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onClick: (templateId) => dispatch(copyTemplate(ownProps.api, ownProps.clientId, templateId)),
    };
}

Templates.propTypes = {
    api: PropTypes.object.isRequired,
    templates: PropTypes.arrayOf(PropTypes.object).isRequired,
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(Templates);
