import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";

import { Grid, Row, Col } from "react-bootstrap";
import { Button } from "@yandex-lego/components/Button/desktop/bundle";

import ClientsPanel from "../UploadingPanel/ClientsPanel";
import Templates from "./Templates";

import "./index.scss";

import { createTemplate, catalog } from "../actions";

class CatalogPanel extends React.Component {
    renderCatalog() {
        const { clientId, clients, templates, api, getTemplates, createNewTemplate } = this.props;
        return (
            <Grid fluid={true}>
                <Row>
                    <Col md={9}>
                        <ClientsPanel
                            selectedClientId={clientId}
                            clients={clients}
                            onClick={(clientId) => getTemplates(clientId)}
                        />
                    </Col>
                    <Col md={3}>
                        <div className="FieldLayout">
                            <span className="pull-right">
                                <Button
                                    view="default"
                                    theme="raised"
                                    size="s"
                                    onClick={() => createNewTemplate(clientId)}
                                >
                                    + Создать шаблон
                                </Button>
                            </span>
                        </div>
                    </Col>
                </Row>
                <Row>
                    <Col md={12}>
                        <div className="FieldLayout">
                            <Templates api={api} clientId={clientId} templates={templates} />
                        </div>
                    </Col>
                </Row>
            </Grid>
        );
    }

    render() {
        return <div>{this.renderCatalog()}</div>;
    }
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        getTemplates: (clientId) => dispatch(catalog(ownProps.api, clientId)),
        createNewTemplate: (clientId) => dispatch(createTemplate(clientId)),
    };
}

function mapStateToProps(state, ownProps) {
    return {};
}

CatalogPanel.propTypes = {
    api: PropTypes.object.isRequired,
    clientId: PropTypes.number.isRequired,
    clients: PropTypes.arrayOf(PropTypes.object).isRequired,
    templates: PropTypes.arrayOf(PropTypes.object).isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(CatalogPanel);
