import React from "react";
import { Button } from "@yandex-lego/components/Button/desktop/bundle";

class ClonableContainer extends React.Component {
    static renderSeparator(i) {
        if (i > 0) {
            return <hr />;
        } else {
            return null;
        }
    }
    renderElement(i) {
        return (
            <div key={this.props.children[i].key}>
                {ClonableContainer.renderSeparator(i)}
                {this.props.children[i]}
            </div>
        );
    }

    render() {
        const elements = this.props.children.map((_, i) => this.renderElement(i));
        return (
            <div>
                {elements}
                <div className={this.props.buttonClassName}>
                    <Button view="default" theme="raised" size="s" onClick={() => this.props.onClone()}>
                        + Добавить
                    </Button>
                    &nbsp;
                    <Button
                        view="default"
                        theme="raised"
                        size="s"
                        onClick={() => this.props.onCopy(this.props.children[this.props.children.length - 1].key)}
                    >
                        + Скопировать
                    </Button>
                </div>
            </div>
        );
    }
}

export default ClonableContainer;
