import React from "react";
import { Grid, Row, Col } from "react-bootstrap";

class FlexGrid extends React.Component {
    renderRow(start_index, offset) {
        const items = [];
        for (let i = start_index; i < start_index + offset; ++i) {
            items.push(this.renderCol(i));
        }
        return <Row key={start_index}>{items}</Row>;
    }

    renderCol(i) {
        if (i < this.props.children.length) {
            return (
                <Col md={12 / this.props.md} key={i}>
                    {this.props.children[i]}
                </Col>
            );
        } else {
            return null;
        }
    }

    render() {
        const items = [];
        let start_index = 0;
        while (start_index < this.props.children.length) {
            items.push(this.renderRow(start_index, this.props.md));
            start_index += this.props.md;
        }
        return <Grid fluid={true}>{items}</Grid>;
    }
}

export default FlexGrid;
