import React from "react";
import { Modal } from "@yandex-lego/components/Modal/desktop/bundle";

import ClosableContainer from "../ClosableContainer";

import "./index.scss";

class ModalContainer extends React.Component {
    render() {
        return (
            <Modal theme="normal" visible={this.props.visible} onClose={() => this.props.onClose()}>
                <ClosableContainer onClose={() => this.props.onClose()}>
                    <div>
                        <div className="ModalText">{this.props.children}</div>
                    </div>
                </ClosableContainer>
            </Modal>
        );
    }
}

export default ModalContainer;
