import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";

import { ListGroup, ListGroupItem } from "react-bootstrap";

import "./index.scss";
import "./AdGroupsPanel.scss";

import { previewAdGroup } from "../actions/Preview";

class AdGroupsPanel extends React.Component {
    renderAdGroup(adGroup) {
        const { adGroupActiveId, onSelectAdGroup } = this.props;
        return (
            <ListGroupItem
                active={adGroupActiveId === adGroup.id}
                key={adGroup.id}
                onClick={() => onSelectAdGroup(adGroup.id)}
            >
                <div>{adGroup.name}</div>
            </ListGroupItem>
        );
    }

    render() {
        const { adGroups } = this.props;
        const renderedAdGroups = adGroups.map((adGroup) => this.renderAdGroup(adGroup));
        return (
            <div>
                <div>Группы объявлений ({adGroups.length})</div>
                <div className="AdGroups">
                    <div className="HalfScrollingBlock">
                        <ListGroup>{renderedAdGroups}</ListGroup>
                    </div>
                </div>
            </div>
        );
    }
}

function mapStateToProps(state) {
    return {
        adGroups: state.previewPanel.adGroups.values,
        adGroupActiveId: state.previewPanel.adGroups.active,
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onSelectAdGroup: (adGroupId) =>
            dispatch(
                previewAdGroup(ownProps.api, ownProps.clientId, ownProps.templateId, ownProps.campaignId, adGroupId)
            ),
    };
}

AdGroupsPanel.propTypes = {
    templateId: PropTypes.number.isRequired,
    campaignId: PropTypes.number.isRequired,
    clientId: PropTypes.number.isRequired,
    api: PropTypes.object.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(AdGroupsPanel);
