import React from "react";
import { Media } from "react-bootstrap";
import { connect } from "react-redux";

import "./index.scss";
import "./BannersPanel.scss";

class BannersPanel extends React.Component {
    renderBanner(banner) {
        return (
            <Media key={banner.id} bsClass="media BannerDivBordered">
                <Media.Left bsClass="BannerDiv">
                    <img height={64} src={banner.uploaded_image.url} role="presentation" />
                </Media.Left>
                <Media.Body bsClass="BannerDiv">
                    <Media.Heading>
                        <a href={banner.href}>{banner.title}</a>
                    </Media.Heading>
                    <p>{banner.text} </p>
                </Media.Body>
            </Media>
        );
    }

    render() {
        const { banners } = this.props;
        const renderedBanners = banners.map((banner) => this.renderBanner(banner));
        return (
            <div className="ScrollingDiv">
                <div>Баннера ({banners.length})</div>
                <div className="ScrollingDiv">
                    <div className="ScrollingBlock">
                        <div className="FieldPadding">
                            <Media.List>{renderedBanners}</Media.List>
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}

function mapStateToProps(state, ownProps) {
    return {
        banners: state.previewPanel.banners,
    };
}

BannersPanel.propTypes = {};

export default connect(mapStateToProps)(BannersPanel);
