import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";
import { ListGroup, ListGroupItem } from "react-bootstrap";

import "./index.scss";
import "./CampaignsPanel.scss";

import { previewCampaign } from "../actions/Preview";

class CampaignsPanel extends React.Component {
    renderCampaign(campaign) {
        const { campaignActiveId, onSelectCampaign } = this.props;
        return (
            <ListGroupItem
                active={campaignActiveId === campaign.id}
                key={campaign.id}
                onClick={() => onSelectCampaign(campaign.id)}
            >
                <div>{campaign.name}</div>
            </ListGroupItem>
        );
    }

    render() {
        const { campaigns } = this.props;
        const renderedCampaigns = campaigns.map((campaign) => this.renderCampaign(campaign));
        return (
            <div>
                <div>Кампании ({campaigns.length})</div>
                <div className="Campaigns">
                    <div className="HalfScrollingBlock">
                        <ListGroup>{renderedCampaigns}</ListGroup>
                    </div>
                </div>
            </div>
        );
    }
}

function mapStateToProps(state) {
    return {
        campaigns: state.previewPanel.campaigns.values,
        campaignActiveId: state.previewPanel.campaigns.active,
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onSelectCampaign: (campaignId) =>
            dispatch(previewCampaign(ownProps.api, ownProps.clientId, ownProps.templateId, campaignId)),
    };
}

CampaignsPanel.propTypes = {
    templateId: PropTypes.number.isRequired,
    clientId: PropTypes.number.isRequired,
    api: PropTypes.object.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(CampaignsPanel);
