import React from "react";
import { connect } from "react-redux";

import "./PhrasesPanel.scss";

class PhrasesPanel extends React.Component {
    renderPhrase(phrase) {
        return (
            <div key={phrase.id} className="Phrase">
                {phrase.name}
            </div>
        );
    }
    render() {
        const { phrases } = this.props;
        const renderedPhrases = this.props.phrases.map((phrase) => this.renderPhrase(phrase));
        return (
            <div>
                <div>Фразы ({phrases.length})</div>
                <div className="ScrollingDiv">
                    <div className="ScrollingBlock Phrases">{renderedPhrases}</div>
                </div>
            </div>
        );
    }
}

function mapStateToProps(state, ownProps) {
    return {
        phrases: state.previewPanel.phrases,
    };
}

PhrasesPanel.propTypes = {};

export default connect(mapStateToProps)(PhrasesPanel);
