import React from "react";
import PropTypes from "prop-types";
import { connect } from "react-redux";

import { Textarea } from "@yandex-lego/components/Textarea/desktop/bundle";
import { Textinput } from "@yandex-lego/components/Textinput/desktop/bundle";

import "./AdGroup.scss";

import { editAdGroupPhrases, editAdGroupName } from "../actions/Upload";
import { splitTextField } from "../actions/utils";

class AdGroup extends React.Component {
    render() {
        const { adGroup, onPhrasesChange, onNameChange } = this.props;
        return (
            <div>
                <div className="FieldLayout">
                    <div>Имя группы</div>
                    <Textinput
                        className="NameTextInput"
                        size="m"
                        hasClear
                        placeholder="Погода"
                        view="default"
                        value={adGroup.name}
                        onChange={(event) => onNameChange(event.target.value)}
                    />
                </div>
                <div className="FieldLayout">
                    <div>Фразы</div>
                    <Textarea
                        className="GroupPhrasesInput"
                        size="m"
                        hasClear
                        view="default"
                        placeholder={"погода (Москва)\nпрогноз погода\nпрогноз (Москва)"}
                        value={adGroup.phrases.join("\n")}
                        onChange={(event) => onPhrasesChange(splitTextField(event.target.value))}
                    />
                </div>
            </div>
        );
    }
}

function getAdGroup(state, clientId, adGroupId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    const adGroups = state.clients[clientIndex].adGroups;
    const adGroupsIndex = adGroups.findIndex((value) => value.id === adGroupId);
    return adGroups[adGroupsIndex];
}

function mapStateToProps(state, ownProps) {
    return {
        adGroup: getAdGroup(state, ownProps.clientId, ownProps.adGroupId),
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onPhrasesChange: (phrases) => dispatch(editAdGroupPhrases(ownProps.clientId, ownProps.adGroupId, phrases)),
        onNameChange: (name) => dispatch(editAdGroupName(ownProps.clientId, ownProps.adGroupId, name)),
    };
}

AdGroup.propTypes = {
    adGroupId: PropTypes.string.isRequired,
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(AdGroup);
