import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";

import ClonableContainer from "../ClonableContainer";
import ClosableContainer from "../ClosableContainer";

import AdGroup from "./AdGroup.js";

import "./index.scss";

import { addAdGroup, copyAdGroup, removeAdGroup } from "../actions/Upload";
import { uniqueId } from "lodash";

class AdGroupsPanel extends React.Component {
    renderAdGroup(adGroup) {
        const { clientId } = this.props;
        return <AdGroup adGroupId={adGroup.id} clientId={clientId} />;
    }

    renderClosableAdGroup(adGroup) {
        const { onRemoveAdGroup } = this.props;
        return (
            <ClosableContainer key={adGroup.id} onClose={() => onRemoveAdGroup(adGroup.id)}>
                {this.renderAdGroup(adGroup)}
            </ClosableContainer>
        );
    }

    render() {
        const { adGroups, onAddAdGroup, onCopyAdGroup } = this.props;
        const closableAdGroups = adGroups.map((adGroup) => this.renderClosableAdGroup(adGroup));
        return (
            <ClonableContainer
                onClone={() => onAddAdGroup()}
                onCopy={(adGroupId) => onCopyAdGroup(adGroupId)}
                buttonClassName="FieldLayout"
            >
                {closableAdGroups}
            </ClonableContainer>
        );
    }
}

function getAdGroupsByClientId(state, clientId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    return state.clients[clientIndex].adGroups;
}

function mapStateToProps(state, ownProps) {
    return {
        adGroups: getAdGroupsByClientId(state, ownProps.clientId),
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onAddAdGroup: () => dispatch(addAdGroup(ownProps.clientId, uniqueId())),
        onCopyAdGroup: (adGroupId) => dispatch(copyAdGroup(ownProps.clientId, adGroupId, uniqueId())),
        onRemoveAdGroup: (adGroupId) => dispatch(removeAdGroup(ownProps.clientId, adGroupId)),
    };
}

AdGroupsPanel.propTypes = {
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(AdGroupsPanel);
