import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";

import { Textarea } from "@yandex-lego/components/Textarea/desktop/bundle";
import { Textinput } from "@yandex-lego/components/Textinput/desktop/bundle";
import { Checkbox } from "@yandex-lego/components/Checkbox/desktop/bundle";

import "./Banner.scss";

import { editBannerTitles, editBannerTexts, editBannerHrefs, editBannerParams, selectImages } from "../actions/Upload";

import { splitTextField, APIStatusEnum } from "../actions/utils";

class Banner extends React.Component {
    renderImage(image, selectedImages) {
        const { onImagesSelect } = this.props;
        const checked = selectedImages.findIndex((value) => value === image.id) !== -1;
        return (
            <div key={image.id} className="check">
                <Checkbox
                    theme="normal"
                    size="s"
                    checked={checked}
                    onChange={() => {
                        if (checked) {
                            onImagesSelect(selectedImages.filter((value) => value !== image.id));
                        } else {
                            onImagesSelect(selectedImages.concat([image.id]));
                        }
                    }}
                />
                <img className="img-thumbnail" src={image.direct.url} alt="" />
            </div>
        );
    }

    renderParam(key, value) {
        const { onParamChange } = this.props;

        let placeholder;
        switch (key) {
            case "utm_source":
                placeholder = "yandex";
                break;
            case "utm_term":
                placeholder = "(в Москве)";
                break;
            case "utm_campaign":
                placeholder = "pogoda_rsya_auto";
                break;
            case "utm_medium":
                placeholder = "rsya";
                break;
            default:
                placeholder = "";
        }
        return (
            <table key={key}>
                <tbody>
                    <tr>
                        <td className="BannerParamsInput">{key}:&nbsp;</td>
                        <td className="BannerParamsInput">
                            <Textinput
                                view="default"
                                size="s"
                                placeholder={placeholder}
                                value={value}
                                onChange={(event) => onParamChange(key, event.target.value)}
                            />
                        </td>
                    </tr>
                </tbody>
            </table>
        );
    }

    render() {
        const { banner, images, onTitlesChange, onTextsChange, onHrefsChange } = this.props;
        const params = Object.keys(banner.href_params).map((key) => this.renderParam(key, banner.href_params[key]));
        const renderedImages = images.map((image) => this.renderImage.bind(this)(image, banner.imageIds));
        return (
            <div>
                <div className="FieldLayout">
                    <div>Заголовки баннера</div>
                    <Textarea
                        view="default"
                        size="s"
                        placeholder={"(В Москве) будет холодна зима?\nНовости (Москвы)."}
                        text={banner.titles.join("\n")}
                        onChange={(titles) => onTitlesChange(splitTextField(titles))}
                    />
                </div>
                <div className="FieldLayout">
                    <div>Тексты баннера</div>
                    <Textarea
                        view="default"
                        size="s"
                        placeholder={
                            "Cмотрите погоду (в Москве) на Яндексе.\nЧто происходит (в Москве)? Читайте новости (Москвы) на Яндексе."
                        }
                        value={banner.texts.join("\n")}
                        onChange={(event) => onTextsChange(splitTextField(event.target.value))}
                    />
                </div>
                <div className="FieldLayout">
                    <div>Лендинги</div>
                    <Textarea
                        view="default"
                        size="s"
                        placeholder={"https://ya.ru/set/pogoda/1\nhttps://ya.ru/set/pogoda/2"}
                        value={banner.hrefs.join("\n")}
                        onChange={(event) => onHrefsChange(splitTextField(event.target.value))}
                    />
                </div>
                <div className="FieldLayout">{params}</div>
                <div className="FieldLayout">
                    {renderedImages}
                    <br className="check3" />
                </div>
            </div>
        );
    }
}

function getBanner(state, clientId, bannerId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    const banners = state.clients[clientIndex].banners;
    const bannerIndex = banners.findIndex((value) => value.id === bannerId);
    return banners[bannerIndex];
}

function getImages(state, clientId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    return state.clients[clientIndex].images;
}

function mapStateToProps(state, ownProps) {
    return {
        banner: getBanner(state, ownProps.clientId, ownProps.bannerId),
        images: getImages(state, ownProps.clientId).filter(
            (image) => image.uploadingStatus.status === APIStatusEnum.SUCCESS
        ),
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onTitlesChange: (titles) => dispatch(editBannerTitles(ownProps.clientId, ownProps.bannerId, titles)),
        onTextsChange: (texts) => dispatch(editBannerTexts(ownProps.clientId, ownProps.bannerId, texts)),
        onHrefsChange: (hrefs) => dispatch(editBannerHrefs(ownProps.clientId, ownProps.bannerId, hrefs)),
        onParamChange: (key, value) => dispatch(editBannerParams(ownProps.clientId, ownProps.bannerId, key, value)),
        onImagesSelect: (images) => dispatch(selectImages(ownProps.clientId, ownProps.bannerId, images)),
    };
}

Banner.propTypes = {
    bannerId: PropTypes.string.isRequired,
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(Banner);
