import React from "react";
import { connect } from "react-redux";
import PropTypes from "prop-types";
import { uniqueId } from "lodash";

import ClonableContainer from "../ClonableContainer";
import ClosableContainer from "../ClosableContainer";

import Banner from "./Banner.js";
import "./index.scss";

import { addBanner, copyBanner, removeBanner } from "../actions/Upload";

class BannersPanel extends React.Component {
    renderBanner(banner) {
        const { clientId } = this.props;
        return <Banner bannerId={banner.id} clientId={clientId} />;
    }

    renderClosableBanner(banner) {
        const { onRemoveBanner } = this.props;
        return (
            <ClosableContainer key={banner.id} onClose={() => onRemoveBanner(banner.id)}>
                {this.renderBanner(banner)}
            </ClosableContainer>
        );
    }

    render() {
        const { banners, onAddBanner, onCopyBanner } = this.props;
        const closableBanners = banners.map((banner) => this.renderClosableBanner(banner));
        return (
            <ClonableContainer
                onClone={() => onAddBanner()}
                onCopy={(bannerId) => onCopyBanner(bannerId)}
                buttonClassName="FieldLayout"
            >
                {closableBanners}
            </ClonableContainer>
        );
    }
}

function getBannersByClientId(state, clientId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    return state.clients[clientIndex].banners;
}

function mapStateToProps(state, ownProps) {
    return {
        banners: getBannersByClientId(state, ownProps.clientId),
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onAddBanner: () => dispatch(addBanner(ownProps.clientId, uniqueId())),
        onCopyBanner: (bannerId) => dispatch(copyBanner(ownProps.clientId, bannerId, uniqueId())),
        onRemoveBanner: (bannerId) => dispatch(removeBanner(ownProps.clientId, bannerId)),
    };
}

BannersPanel.propTypes = {
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(BannersPanel);
