import React from "react";
import PropTypes from "prop-types";
import { connect } from "react-redux";

import { Textinput } from "@yandex-lego/components/Textinput/desktop/bundle";

import { editCampaignName, editCampaignBid } from "../actions/Upload";

class CampaignPanel extends React.Component {
    render() {
        const { campaign, onNameChange, onBidChange } = this.props;
        return (
            <div>
                <div className="FieldLayout">
                    <div>Имя кампании</div>
                    <Textinput
                        className="NameTextInput"
                        view="default"
                        size="m"
                        placeholder="PogodaRsyaAuto"
                        value={campaign.name}
                        onChange={(event) => onNameChange(event.target.value)}
                    />
                </div>
                <div className="FieldLayout">
                    <div>Ставка в фишках</div>
                    <Textinput
                        className="NameTextInput"
                        view="default"
                        size="m"
                        placeholder="700000"
                        type="number"
                        value={campaign.bid}
                        onChange={(event) => onBidChange(event.target.value)}
                    />
                </div>
            </div>
        );
    }
}

function getCampaignByClientId(state, clientId) {
    const clientIndex = state.clients.findIndex((value) => value.id === clientId);
    return state.clients[clientIndex].campaign;
}

function mapStateToProps(state, ownProps) {
    return {
        campaign: getCampaignByClientId(state, ownProps.clientId),
    };
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onNameChange: (name) => dispatch(editCampaignName(ownProps.clientId, name)),
        onBidChange: (bid) => dispatch(editCampaignBid(ownProps.clientId, bid)),
    };
}

CampaignPanel.propTypes = {
    clientId: PropTypes.number.isRequired,
};

export default connect(mapStateToProps, mapDispatchToProps)(CampaignPanel);
