import React from "react";
import PropTypes from "prop-types";

import { connect } from "react-redux";
import { RadioButton } from "@yandex-lego/components/RadioButton/desktop/bundle";

import { selectClient } from "../actions";

import "./index.scss";

class ClientsPanel extends React.Component {
    render() {
        const { clients, selectedClientId, onClientSelect } = this.props;
        return (
            <RadioButton
                value={selectedClientId}
                view="default"
                size="s"
                onChange={(event) => onClientSelect(parseInt(event.target.value))}
                options={clients.map((client) => ({ value: client.id, children: client.name }))}
            />
        );
    }
}

function mapStateToProps(state) {
    return {};
}

function onClick(dispatch, ownProps, clientId) {
    dispatch(selectClient(clientId));
    if (ownProps.onClick) {
        ownProps.onClick(clientId);
    }
}

function mapDispatchToProps(dispatch, ownProps) {
    return {
        onClientSelect: (clientId) => onClick(dispatch, ownProps, clientId),
    };
}

ClientsPanel.propTypes = {
    selectedClientId: PropTypes.number.isRequired,
    clients: PropTypes.arrayOf(PropTypes.object).isRequired,
    onClick: PropTypes.func,
};

export default connect(mapStateToProps, mapDispatchToProps)(ClientsPanel);
